/** 
 * @file    kPort.h
 * @brief   Declares the kPort class. 
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PORT_H
#define K_FIRESYNC_PORT_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kPort
 * @extends kObject
 * @ingroup kFireSync-Client
 * @brief   Represents port configuration.
 */
//typedef kObject kPort;        --forward-declared in kFsDef.x.h

/** 
 * Gets the unique identifier for this port. 
 *
 * The port identifier is used when external references to the port are needed. For example, 
 * the port identifier is used in the kRoutePoint structure to specify the port segment of a 
 * route end point.
 *
 * @public              @memberof kPort
 * @param   port        Port object.  
 * @return              Returns the unique identifier for this port. 
 */
kFsFx(k32u) kPort_Id(kPort port);

/** 
 * Gets a descriptive name for the port. 
 *
 * @public              @memberof kPort
 * @param   port        Port object.  
 * @return              Port name. 
 */
kFsFx(const kChar*) kPort_Name(kPort port);

/** 
 * Gets the directionality (input/output) of the port. 
 *
 * @public              @memberof kPort
 * @param   port        Port object.  
 * @return              Returns the directionality (input/output) of the port. 
 */
kFsFx(kPortDirection) kPort_Direction(kPort port);

#include <kFireSync/Client/kPort.x.h>

#endif
