/** 
 * @file    kLightState.x.h
 *
 * @internal
 * Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LIGHT_STATE_X_H
#define K_FIRESYNC_LIGHT_STATE_X_H

typedef struct kLightStateClass
{
    kObjectClass base; 

    kNode node; 
    kLight light; 
    kSize index; 

    k64u delay; 
    k64u exposure; 
    k64u gap; 

    kArrayList nextStates;       //temp variable, used in validation -- kArrayList<kSize> 

} kLightStateClass; 

kDeclareClassEx(kFs, kLightState, kObject)
        
kFsFx(kStatus) kLightState_Construct(kLightState* state, kNode node, kLight light, kSize index, kAlloc allocator); 

kFsFx(kStatus) kLightState_Init(kLightState state, kType type, kNode node, kLight light, kSize index, kAlloc alloc); 
kFsFx(kStatus) kLightState_VRelease(kLightState state); 

kFsFx(kStatus) kLightState_Parse(kLightState state, kXml xml, kXmlItem item); 
kFsFx(kStatus) kLightState_Format(kLightState state, kXml xml, kXmlItem item); 

kFsFx(kStatus) kLightState_VerificationLabel(kLightState state, kChar* label, kSize capacity); 
kFsFx(kStatus) kLightState_Verify(kLightState state); 

kFsFx(kStatus) kLightState_SetIndex(kLightState state, kSize index); 

#endif
