/** 
 * @file    kDp03Info.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DP03_INFO_X_H
#define K_FIRESYNC_DP03_INFO_X_H

#define kDP03_WIDTH                             (1280)
#define kDP03_HEIGHT                            (720)

#define kDP03_MIN_PATTERN_COUNT                 (1)                 ///< Minimum pattern count.
#define kDP03_MAX_PATTERN_COUNT                 (96)                ///< Maximum pattern count.
#define kDP03_MAX_FRAME_REPEAT_COUNT            (255)               ///< Maximum frame repeat count.

#define kDP03_MIN_BIT_DEPTH                     (8)                 ///< Minimum pattern bit depth.
#define kDP03_MAX_BIT_DEPTH                     (8)                 ///< Maximum pattern bit depth.
#define kDP03_DEFAULT_BIT_DEPTH                 (8)                 ///< Default pattern bit depth.

#define kDP03_MIN_INTENSITY                     (0)                 ///< Minimum intensity.
#define kDP03_MAX_INTENSITY                     (0x3FF)             ///< Maximum intensity.
#define kDP03_DEFAULT_INTENSITY                 (k32U_MAX)          ///< Default intensity. 
               
#define kDP03_MIN_PALETTE_COLOR                 (0)                 ///< Minimum palette color.
#define kDP03_MAX_PALETTE_COLOR                 (255)               ///< Maximum palette color.

#define kDP03_HSYNC_WIDTH                       (8)                 ///< HSync width.
#define kDP03_HSYNC_BACK_PORCH                  (16)                ///< HSync back porch.
#define kDP03_HSYNC_FRONT_PORCH                 (16)                ///< HSync front porch.
#define kDP03_VSYNC_WIDTH                       (10)                ///< VSync width.
#define kDP03_VSYNC_MAX_BACK_PORCH              (250)               ///< Maximum VSync back porch.
#define kDP03_VSYNC_MIN_BLANKING                (50)                ///< Minimum VSync blanking (width + frontPorch + backPorch).

#define kDP03_INFO_MIN_EXPOSURE                 (0)                 ///< DP03 minimum exposure (real ns).
#define kDP03_INFO_DEFAULT_EXPOSURE             (2000000)           ///< DP03 default exposure (real ns).

#define kDP03_INFO_PILOT_RUN_EXPOSURE           (16000000)          ///< DP03 pilot run exposure.
#define kDP03_INFO_PILOT_RUN_PERIOD             (17180000)          ///< DP03 pilot run period.
#define kDP03_INFO_PILOT_RUN_INTENSITY          (512)               ///< DP03 pilot run intensity.
#define kDP03_INFO_MIN_SEQUENCE_GAP             (12000000)          ///< DP03 minimum gap between sequences.

#define kDP03_PATTERN_MAX_EXPOSURE              (15348)             ///< DLPC3478 maximum exposure time (real us).
#define kDP03_PATTERN_MIN_EXPOSURE              (2555)              ///< DLPC3478 minimum exposure time (real us).
#define kDP03_PATTERN_MIN_PRE_EXP_DARK_TIME     (171)               ///< DLPC3478 minimum pre-exposure dark time (real us).
#define kDP03_PATTERN_MIN_POST_EXP_DARK_TIME    (31)                ///< DLPC3478 minimum post-exposure dark time (real us).

#define kDP03_PATTERN_3_IMAGES_THRESHOLD        (4141)
#define kDP03_PATTERN_2_IMAGES_THRESHOLD        (8282)

#define kDP03_ELIMINATE_FLICKER_FACTOR          (500000)            ///< Factor to eliminate flicker for one pattern projecting (real ns).

typedef struct kDp03InfoClass
{
    kProjectorInfoClass base; 
} kDp03InfoClass;

kDeclareClassEx(kFs, kDp03Info, kProjectorInfo)
        
kFsFx(kStatus) kDp03Info_Init(kDp03Info info, kType type, k64f pixelClockFrequency, kAlloc alloc);
kFsFx(kStatus) kDp03Info_VRelease(kDp03Info info);

kFsFx(k64u) kDp03Info_FrameTime(kDp03Info info, kDp03Timing* dp03Timing);
kFsFx(k64u) kDp03Info_VImageTime(kDp03Info info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(k64u) kDp03Info_VFrameTime(kDp03Info info, kSize bitDepth, k64u exposure, kBool dynFrameRate);
kFsFx(kStatus) kDp03Info_VCalculateExposure(kDp03Info info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kProjectorTiming* timing);
kFsFx(k64u) kDp03Info_VSequenceDuration(kDp03Info info, kSize bitDepth, k64u exposur, k64u cameraDuratione, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled);
kFsFx(k64u) kDp03Info_VMinimumGap(kDp03Info info, kSize bitDepth, k64u exposure, k64u cameraDuration, kBool dynFrameRate, kSize patternCount, kBool sequenceEnabled, k64u cameraPlProcessingTime);
kFsFx(k64u) kDp03Info_VNominateCameraExposure(kDp03Info info, kSize bitDepth, k64u stateExposure, k64u cameraDuration, kBool dynFrameRate, k64u desiredExposure);
kFsFx(k64u) kDp03Info_VMinExposure(kDp03Info info, k32u intensity, k32u minIntensity);
kFsFx(kProjectorExtension) kDp03Info_VExtensionTypes(kDp03Info info);

#endif
