/** 
 * @file    kProjectorExt.h
 * @brief   Declares the kProjectorExt type. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_PROJECTOR_EXT_H
#define K_FIRESYNC_PROJECTOR_EXT_H

#include <kFireSync/kNodeDef.h>

/**
 * @class   kProjectorExt
 * @extends kObject
 * @ingroup kFireSync-Client-Projector-Extensions
 * @brief   Abstract base class for projector control extension parameters. 
 * 
 * Note to implementers: kProjectorExt and its derived types are used in both client and server/hardware contexts. 
 * This approach reduces code duplication, but imposes some complexity/limitations on the implementation. 
 * Because these types can be used separately from the kFireSync/Client object hierarchy, it cannot be assumed 
 * that a sequence object has a reference to its client-side parent (kProjector). 
 */
//typedef kObject kProjectorExt;             --forward-declared in kFsDef.x.h

/** 
 * Enables or disables the extension. 
 *
 * @public              @memberof kProjectorExt
 * @param   extension   Extneion object.  
 * @param   enable      Specifies whether to enable or disable the extension.  
 * @return              Operation status. 
 */
kFsFx(kStatus) kProjectorExt_Enable(kProjectorExt extension, kBool enable);

/** 
 * Reports whether the extension is currently enabled. 
 *
 * @public              @memberof kProjectorExt
 * @param   extension   Extneion object.  
 * @return              Returns whether the extension is currently enabled. 
 */
kFsFx(kBool) kProjectorExt_IsEnabled(kProjectorExt extension);

#include <kFireSync/Client/Projector/Extensions/kProjectorExt.x.h>

#endif
