/** 
 * @file    kNode5Client.h
 * @brief   Declares the kNode5Client class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_NODE_5_CLIENT_H
#define K_FIRESYNC_NODE_5_CLIENT_H

#include <kFireSync/kNodeDef.h>

/**
 * @internal
 * @class       kNode5Client
 * @extends     kObject
 * @implements  kNodeProvider
 * @ingroup     kFireSync-Client-Network
 * @brief       Provides an implementation of the kNodeProvider interface based on FireSync 5 protcols.
 */
//typedef kObject kNode5Client;            --forward-declared in kFsDef.x.h 

/** 
 * Constructs a kNode5Client object.
 *
 * @public              @memberof kNode5Client
 * @return              Operation status. 
 */
kFsFx(kStatus) kNode5Client_Construct(kNode5Client* client, kIpAddress address, k32u id, kAlloc allocator); 

kFsFx(kStatus) kNode5Client_BeginOpenControl(kNode5Client client); 
kFsFx(kStatus) kNode5Client_CloseControl(kNode5Client client); 

kFsFx(kStatus) kNode5Client_WriteFirmware(kNode5Client client, kNodeFirmwareType type, kStream stream, kSize size, kCallbackFx progress, kPointer context); 
kFsFx(kStatus) kNode5Client_Reset(kNode5Client client, kBool restartApp); 

kFsFx(kStatus) kNode5Client_GetInfo(kNode5Client client, kNodeInfo* info);

#include <kFireSync/Client/Network/kNode5Client.x.h>

#endif
