/** 
 * @file    kHealth6Client.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_HEALTH_6_CLIENT_X_H
#define K_FIRESYNC_HEALTH_6_CLIENT_X_H

#include <kApi/Io/kTcpClient.h>

#define kHEALTH_6_CLIENT_CLIENT_READ_BUFFER                (16384)             
#define kHEALTH_6_CLIENT_SOCKET_READ_BUFFER                (16384)             
#define kHEALTH_6_CLIENT_SOCKET_WRITE_BUFFER               (-1) 

#define kHEALTH_6_CLIENT_CONNECT_TIMEOUT                   (1000000)

typedef struct kHealth6ClientClass
{
    kObjectClass base; 

    kCallback receiveFx;                    //Message callback. 
    kAlloc messageAlloc;                    //Message allocator.

    kStatus beginOpenStatus;                //Used to communicate state between BeginOpen/EndOpen.
    kTimer beginOpenTimer;                  //Timer used with BeginOpen operation. 

    kTcpClient client;                      //Connection socket. 
    kSerializer serializer;                 //Message deserializer.

    kThread thread;                         //Receive thread.

    kMap healthIndicatorMap;               //Map of id's to HealtStats - kMap<k16u, kHealthStat> 
    kMap profileIndicatorMap;              //Map of id's to ProbeStats - kMap<k16u, kProfileStat> 
    kBool compressionEnabled;
    k32u nodeId;                           //If compression is enabled this is the sender's node id.

} kHealth6ClientClass; 

kDeclareClassEx(kFs, kHealth6Client, kObject)
        
kFsFx(kStatus) kHealth6Client_Init(kHealth6Client client, kType type, kAlloc alloc); 
kFsFx(kStatus) kHealth6Client_VRelease(kHealth6Client client); 

kFsFx(kStatus) kHealth6Client_ThreadEntry(kHealth6Client client); 

kFsFx(kStatus) kHealth6Client_ReceiveFirstMessage(kHealth6Client client);
kFsFx(kStatus) kHealth6Client_ReceiveNextMessage(kHealth6Client client); 

kFsFx(kStatus) kHealth6Client_ReceiveCompressed(kHealth6Client client, kObject* item); 
kFsFx(kStatus) kHealth6Client_ReceiveCompressedHealth(kHealth6Client client);
kFsFx(kStatus) kHealth6Client_ReceiveCompressedProfile(kHealth6Client client);
kFsFx(kStatus) kHealth6Client_ConstructMessage(kHealth6Client client, kMap source, kObject* item); 

#endif
