/** 
 * @file    kDiscovery6Client.h
 * @brief   Declares the kDiscovery6Client class. 
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_DISCOVERY_6_CLIENT_H
#define K_FIRESYNC_DISCOVERY_6_CLIENT_H

#include <kFireSync/Client/Network/kDiscoveryProvider.h>

/**
 * @internal
 * @class       kDiscovery6Client
 * @extends     kObject
 * @implements  kDiscoveryProvider
 * @ingroup     kFireSync-Client-Network
 * @brief       Provides an implementation of the kDiscoveryProvider interface based on FDP-6.
 */
//typedef kObject kDiscovery6Client;            --forward-declared in kFsDef.x.h
 
/** 
 * Constructs a kDiscovery6Client object.
 *
 * @public              @memberof kDiscovery6Client
 * @return              Operation status. 
 */
kFsFx(kStatus) kDiscovery6Client_Construct(kDiscovery6Client* client, kSystem system, kAlloc allocator); 

kFsFx(kStatus) kDiscovery6Client_SetReceivePort(kDiscovery6Client client, k32u port); 

kFsFx(kStatus) kDiscovery6Client_SetMessageAlloc(kDiscovery6Client client, kAlloc alloc); 

#include <kFireSync/Client/Network/kDiscovery6Client.x.h>

#endif
