/** 
 * @file    kLc130xInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC130X_INFO_X_H
#define K_FIRESYNC_LC130X_INFO_X_H

#define kLC130X_MIN_WIDTH                           (16)                ///< Imager minimum width (pixels).
#define kLC130X_MAX_WIDTH                           (1280)              ///< Imager maximum width (pixels).
#define kLC130X_WIDTH_GRANULARITY                   (8)                 ///< Imager width granularity based on kernel size (pixels).
#define kLC130X_MIN_HEIGHT                          (2)                 ///< Imager minimum height (pixels).
#define kLC130X_MAX_HEIGHT                          (1024)              ///< Imager maximum height (pixels).
#define kLC130X_HEIGHT_GRANULARITY                  (2)                 ///< Imager height granularity (pixels).
#define kLC130X_LEFT_GRANULARITY                    (8)                 ///< Window x granularity (pixels). 
#define kLC130X_TOP_GRANULARITY                     (2)                 ///< Window y granularity (pixels). 
#define kLC130X_PRE_EXPOSURE                             (538)               ///< Lead in (pixel periods).
#define kLC130X_POST_EXPOSURE                            (6654)              ///< Lead out (pixel periods).
#define kLC130X_MIN_EXPOSURE                        (7021)              ///< Minimum exposure (pixel periods).
#define kLC130X_MAX_EXPOSURE                        (1000000000)        ///< Maximum exposure (ns).
#define kLC1300_MAX_IMAGER_X_SUB                    (2)                 ///< Maximum x-subsampling supported by imager.
#define kLC1301_MAX_IMAGER_X_SUB                    (1)                 ///< Maximum x-subsampling supported by imager.
#define kLC130X_MAX_IMAGER_Y_SUB                    (2)                 ///< Maximum y-subsampling supported by imager.
#define kLC130X_IMAGER_X_SUB_OPTIONS                (3)                 ///< X-subsampling options supported by imager.
#define kLC130X_IMAGER_Y_SUB_OPTIONS                (3)                 ///< Y-subsampling options supported by imager.
#define kLC130X_DIGITAL_GAIN_GRANULARITY            (0.0078125)         ///< Digital gain step granularity.
#define kLC130X_DIGITAL_GAIN_MAX_STEP               (3968)              ///< Maximum digital gain step.
#define kLC130X_MIN_BLACK_LEVEL                     (0)                 ///< Minimum black level value.
#define kLC130X_MAX_BLACK_LEVEL                     (0xFF)              ///< Maximum black level value.
#define kLC130X_MIN_KNEE_COUNT                      (0)                 ///< Multi-Slope minimum knee count
#define kLC130X_MAX_KNEE_COUNT                      (2)                 ///< Multi-Slope minimum knee count
#define kLC130X_KNEE_COUNT_GRANULARITY              (1)                 ///< Multi-Slope knee count granularity

#define kLC130X_MIN_INTER_READOUT_GAP               (0)                 ///< Minimum time between end of readout and start of next readout (ns).  

#define kLC130X_DEFAULT_CENTROID_STEP_8K            (32)                ///< Range LUT Default CG step (8K entries)
#define kLC130X_DEFAULT_CENTROID_STEP_16K           (16)                ///< Range LUT Default CG step (16K entries)
#define kLC130X_DEFAULT_VALID_STEP                  (8)                 ///< Range LUT Default valid step
#define kLC130X_DEFAULT_SLICE_STEP                  (8)                 ///< Range LUT Default slice step

/* 
 * register set constants -- refer to imager driver, datasheets, appnotes and characterization document.
 */

#define kLC130X_ROT_IMG_BL_SINGLE_SLOPE             (272)               ///< Single slope ROT length (pixel periods: ~68*4)
#define kLC130X_ROT_IMG_BL_MULTI_SLOPE              (328)               ///< Multi slope ROT length (pixel periods: ~82*4)

#define kLC130X_FOT_SINGLE_SLOPE                    (9984)              ///< Single slope FOT length in pixel clocks (pixel periods)
#define kLC130X_FOT_MULTI_SLOPE                     (13696)             ///< Multi slope FOT length in pixel clocks (pixel periods)

#define kLC130X_MIN_INTER_KNEE_GAP_0                (0)                 ///< Multi slope minimum inter knee gap 0
#define kLC130X_MIN_INTER_KNEE_GAP_1                (9088)              ///< Multi slope minimum inter knee gap 1 (FOT_DS*4: 2272*4)
#define kLC130X_MIN_INTER_KNEE_GAP_2                (768)               ///< Multi slope minimum inter knee gap 2 (FOT_TS*4: 192*4)

#define kLC130X_BLACK_ROW_COUNT                     (4)                 ///< Number of black rows.
#define kLC130X_BLACK_ROWS_GATED                    (2)                 ///< Number of black rows gated.
#define kLC130X_DUMMY_ROW_COUNT                     (1)                 ///< Number of dummy rows.
#define kLC130X_DUMMY_ROWS_GATED                    (0)                 ///< Number of dummy rows gated.

typedef struct kLc130xInfoClass
{
    kCameraInfoClass base; 
    k32u placeholder;
} kLc130xInfoClass; 

kDeclareClassEx(kFs, kLc130xInfo, kCameraInfo)
        
kFsFx(kStatus) kLc130xInfo_Init(kLc130xInfo info, kType type, kCameraModel model, kCameraCapability capabilities, kBool isTrailingRequired, kSize frameSizeGranularity, kVersion plVersion, kAlloc alloc);
kFsFx(kStatus) kLc130xInfo_VRelease(kLc130xInfo info);

kFsFx(kBool) kLc130xInfo_VHasGainChannel(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc130xInfo_VMaxGainStep(kCameraInfo info, kCameraGain channel);
kFsFx(k32u) kLc130xInfo_VGainStep(kLc130xInfo info, kCameraGain channel, k64f gain);
kFsFx(k64f) kLc130xInfo_VGainFactor(kLc130xInfo info, kCameraGain channel, k32u index);

kFsFx(k32u) kLc130xInfo_DigitalGainStep(kLc130xInfo info, k64f gain);
kFsFx(k64f) kLc130xInfo_DigitalGainFactor(kLc130xInfo info, k32u index);
kFsFx(k32u) kLc130xInfo_ColorGainStep(kLc130xInfo info, k64f gain);
kFsFx(k64f) kLc130xInfo_ColorGainFactor(kLc130xInfo info, k32u index);

kFsFx(k64f) kLc130xInfo_FrameOverheadTime(kLc130xInfo info, k64f pixelPeriod, kBool gammaEnabled);
kFsFx(k64f) kLc130xInfo_RowTime(kLc130xInfo info, k32u pixelCount, k64f pixelPeriod, kBool gammaEnabled);
kFsFx(k64f) kLc130xInfo_MinInterKneeGap(kLc130xInfo info, kSize slopeIndex, k64f pixelPeriod);
kFsFx(k64f) kLc130xInfo_MinGammaExposure(kLc130xInfo info, k64f pixelPeriod, const kPoint64f* kneePoints, kSize kneeCount);

kFsFx(k64f) kLc130xInfo_ReadoutTime(kLc130xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc130xInfo_VReadoutTime(kLc130xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc130xInfo_VMinInterExposureGap(kLc130xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc130xInfo_VMinInterReadoutGap(kLc130xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc130xInfo_VMinExposure(kLc130xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc130xInfo_VMaxExposure(kLc130xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc130xInfo_VPreExposure(kLc130xInfo info, const kCameraInfoParams* params);
kFsFx(k64f) kLc130xInfo_VPostExposure(kLc130xInfo info, const kCameraInfoParams* params);

#endif
