/** 
 * @file    kCameraOverride.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_OVERRIDE_X_H
#define K_FIRESYNC_CAMERA_OVERRIDE_X_H

typedef struct kCameraOverrideClass
{
    kCameraExtClass base; 
    kArrayList inputPorts;
} kCameraOverrideClass; 

kDeclareClassEx(kFs, kCameraOverride, kCameraExt)

/** 
 * Constructs a kCameraOverride object.
 *
 * @public              @memberof kCameraOverride
 * @param   extension   Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */
kFsFx(kStatus) xkCameraOverride_Construct(kCameraOverride* extension, kAlloc allocator); 

kFsFx(kStatus) kCameraOverride_Init(kCameraOverride extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kCameraOverride_VRelease(kCameraOverride extension); 

kFsFx(kStatus) kCameraOverride_ComposeInputPorts(kCameraOverride extension); 

kFsFx(kStatus) kCameraOverride_VClone(kCameraOverride extension, kCameraOverride other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kCameraOverride_VRead(kCameraOverride extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraOverride_VWrite(kCameraOverride extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraOverride_VNextStates(kCameraOverride extension, kSize stateIndex, kSize stateCount, kArrayList nextStates);

kFsFx(kSize) kCameraOverride_VInputPortCount(kCameraOverride extension); 
kFsFx(kStatus) kCameraOverride_VInputPortInfo(kCameraOverride extension, kSize index, kPortInfo* info);  

kFsFx(kBool) kCameraOverride_VIsInterruptRequired(kCameraOverride extension); 

#endif
