/** 
 * @file    kCameraDynExp.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_CAMERA_DYN_EXP_X_H
#define K_FIRESYNC_CAMERA_DYN_EXP_X_H

#define kCAMERA_DYN_EXP_ENTRY_COUNT                   (8)           //Based on PL documentation.

typedef struct kCameraDynExpEntry
{
    k32u spotThreshold;                 //spot threshold
    k32s adjust;                        //percentage exposure adjustment
} kCameraDynExpEntry; 

kDeclareValueEx(kFs, kCameraDynExpEntry, kValue)

typedef struct kCameraDynExpClass
{
    kCameraExtClass base; 
    k64u minExposure; 
    k32u minSpots; 
    kArray1 adjustTable;                //Lookup steps -- kArray1<kCameraDynExpEntry>
} kCameraDynExpClass; 

kDeclareClassEx(kFs, kCameraDynExp, kCameraExt)

/** 
 * Constructs a kCameraDynExp object.
 *
 * @public              @memberof kCameraDynExp
 * @param   sequence    Destination for the constructed object handle. 
 * @param   allocator   Memory allocator (or kNULL for default). 
 * @return              Operation status. 
 */

kFsFx(kStatus) xkCameraDynExp_Construct(kCameraDynExp* sequence, kAlloc allocator); 

kFsFx(kStatus) kCameraDynExp_Init(kCameraDynExp extension, kType type, kAlloc alloc); 
kFsFx(kStatus) kCameraDynExp_VRelease(kCameraDynExp extension); 

kFsFx(kStatus) kCameraDynExp_VClone(kCameraDynExp extension, kCameraDynExp other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kCameraDynExp_VRead(kCameraDynExp extension, kXml xml, kXmlItem item); 
kFsFx(kStatus) kCameraDynExp_VWrite(kCameraDynExp extension, kXml xml, kXmlItem item); 

kFsFx(kStatus) kCameraDynExp_VClear(kCameraDynExp extension); 

kFsFx(kStatus) kCameraDynExp_VerificationLabel(kCameraDynExp extension, kChar* label, kSize capacity); 
kFsFx(kStatus) kCameraDynExp_VVerify(kCameraDynExp extension); 

kFsFx(kCameraDynExpEntry*) kCameraDynExp_EntryAt(kCameraDynExp extension, kSize index);

#endif
