/** 
 * @file    kBinCSum4Info.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_BINCSUM4_INFO_X_H
#define K_FIRESYNC_BINCSUM4_INFO_X_H

#define kBIN_CSUM4_INFO_DEFAULT_BACKGROUND_WIDTH    (32)        //Number of columns used for background noise. 

#define kBIN_CSUM4_INFO_BIN_THRESHOLD_MSB           (15u)
#define kBIN_CSUM4_INFO_BIN_THRESHOLD_LSB           (8u)

#define kBIN_CSUM4_INFO_CSUM_THRESHOLD_MSB          (7u)
#define kBIN_CSUM4_INFO_CSUM_THRESHOLD_LSB          (0u)

#define kBIN_CSUM4_INFO_AVERAGING_COLS_MSB          (15u)
#define kBIN_CSUM4_INFO_AVERAGING_COLS_LSB          (8u)

typedef struct kBinCSum4InfoClass
{
    kAlgInfoClass base; 
    k32u binThreshold; 
    k32u csumThreshold;
    kSize backgroundWidth;
} kBinCSum4InfoClass; 

kDeclareClassEx(kFs, kBinCSum4Info, kAlgInfo)

kFsFx(kStatus) xkBinCSum4Info_ConstructFramework(kBinCSum4Info* info, kAlloc allocator);

kFsFx(kStatus) kBinCSum4Info_Init(kBinCSum4Info info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kAlloc alloc); 
kFsFx(kStatus) kBinCSum4Info_VRelease(kBinCSum4Info info); 

kFsFx(kStatus) kBinCSum4Info_VClone(kBinCSum4Info info, kBinCSum4Info other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kBinCSum4Info_VToRegisters(kBinCSum4Info info, k32u* reg, kSize capacity, kSize* used, kSize activePipeCount, 
        kSize imageWidth, kSize imgXSubShift, kSize plXSubShift, kSize imageHeight, kSize imgYSubShift, kSize plYSubShift); 
kFsFx(kStatus) kBinCSum4Info_VInitRead(kBinCSum4Info info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kXml xml, kXmlItem item, kAlloc alloc); 
kFsFx(kStatus) kBinCSum4Info_VRead(kBinCSum4Info info, kXml xml, kXmlItem item); 
kFsFx(kStatus) kBinCSum4Info_VWrite(kBinCSum4Info info, kXml xml, kXmlItem item); 
kFsFx(kStatus) kBinCSum4Info_VVerify(kBinCSum4Info info);
kFsFx(kCameraAlgorithm) kBinCSum4Info_VId(kBinCSum4Info info); 
kFsFx(kBool) kBinCSum4Info_VEquals(kBinCSum4Info info, kBinCSum4Info info1);

#endif
