/** 
 * @file    kAcgInfo.x.h
 *
 * @internal
 * Copyright (C) 2013-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_ACG_INFO_X_H
#define K_FIRESYNC_ACG_INFO_X_H

#define kACG_INFO_DEFAULT_MIN_EDGE_WINDOW               (5)
#define kACG_INFO_DEFAULT_MAX_EDGE_WINDOW               (17)
#define kACG_INFO_DEFAULT_MAX_EDGE_GRANULARITY          (2)
#define kACG_INFO_DEFAULT_CG_SCALE                      (0)
#define kACG_INFO_DEFAULT_EDGE_THRESHOLD                (10)
#define kACG_INFO_DEFAULT_MAX_EDGE_THRESHOLD            (255)
#define kACG_INFO_DEFAULT_WIDTH_INTENSITY_THRESHOLD     (0)
#define kACG_INFO_DEFAULT_MIN_WIDTH                     (0)
#define kACG_INFO_DEFAULT_MAX_WIDTH                     (31)
#define kACG_INFO_DEFAULT_MIN_SUM                       (0)
#define kACG_INFO_DEFAULT_MAX_FOUND                     (128)
#define kACG_INFO_DEFAULT_EDGE_WINDOW                   (0)
#define kACG_INFO_DEFAULT_SPOT_FORMAT                   (kACG_SPOT_FORMAT_ENTRY_VALUE)
#define kACG_INFO_DEFAULT_RESAMPLE_BEGIN                (-32000)
#define kACG_INFO_DEFAULT_RESAMPLE_COUNT                (640)
#define kACG_INFO_DEFAULT_RESAMPLE_STEP                 (100)
#define kACG_INFO_DEFAULT_RESAMPLE_STEP_THRESHOLD       (k16S_MAX)
#define kACG_INFO_DEFAULT_RESAMPLE_Z_MIN                (k16S_MIN)
#define kACG_INFO_DEFAULT_RESAMPLE_Z_MAX                (k16S_MAX)

#define kACG_INFO_EXIT_THRESHOLD_MAX                    (k8U_MAX)

#define kACG_INFO_SOBEL_HEIGHT_MASK                     (0x001F)
#define kACG_INFO_SOBEL_HEIGHT_SHIFT                    (0)

#define kACG_INFO_CG_SCALE_MASK                         (0x00C0)
#define kACG_INFO_CG_SCALE_SHIFT                        (6)

#define kACG_INFO_SOBEL_WIDTH_MASK                      (0xFF00)
#define kACG_INFO_SOBEL_WIDTH_SHIFT                     (8)

#define kACG_INFO_EDGE_THRESHOLD_MASK                   (0x00FF)
#define kACG_INFO_EDGE_THRESHOLD_SHIFT                  (0)

#define kACG_INFO_WIDTH_INTENSITY_THRESHOLD_MASK        (0xFF00)
#define kACG_INFO_WIDTH_INTENSITY_THRESHOLD_SHIFT       (8)

#define kACG_INFO_EXIT_INTENSITY_THRESHOLD_MASK         (0xFF0000)
#define kACG_INFO_EXIT_INTENSITY_THRESHOLD_SHIFT        (16)

#define kACG_INFO_SOBEL_FULL_SCALE_FACTOR               (65536)

#define kACG_INFO_AUTO_PATCH_SIZE                       (2000)

#define kACG_INFO_ROW_BASED_SPOT_CAPACITY               (k16U_MAX)
#define kACG_INFO_COL_BASED_SPOT_CAPACITY_2K            (2044)
#define kACG_INFO_COL_BASED_SPOT_CAPACITY_4K            (4092)
#define kACG_INFO_COL_BASED_SPOT_CAPACITY_8K            (8188)
#define kACG_INFO_SORTING_ENABLED_SPOT_CAPACITY         (4094)
#define kACG_INFO_SORTING_ENABLED_32K_SPOT_CAPACITY     (32766)

// To use with the deprecated OutputStage functions
#define kCAMERA_ALGORITHM_OUTPUT_SPOTS                  (0)  
#define kCAMERA_ALGORITHM_OUTPUT_SORTED_SPOTS           (1)  
#define kCAMERA_ALGORITHM_OUTPUT_RANGES                 (2)  

// Used with x-resampling feature
#define kACG_INFO_MAX_RESAMPLING_COUNT_2K               (2048)
#define kACG_INFO_MAX_RESAMPLING_COUNT_4K               (4096)
#define kACG_INFO_MAX_RESAMPLING_COUNT_8K               (8192)
#define kACG_INFO_MAX_RESAMPLING_COUNT_11K              (11000)
#define kACG_INFO_MAX_RESAMPLING_COUNT_16K              (16384)

// FSS-1656: Max found limits recommended using buffer size limit (AFW FIFO size / 8)
#define kACG_INFO_MAX_FOUND_UNSORTED_RAW_CGS_2K         (kACG_INFO_COL_BASED_SPOT_CAPACITY_2K)  // 16K AFW FIFO size; FSH-866
#define kACG_INFO_MAX_FOUND_UNSORTED_RAW_CGS_4K         (4096)                                  // 32K AFW FIFO size
#define kACG_INFO_MAX_FOUND_UNSORTED_RAW_CGS_8K         (8192)                                  // 64K AFW FIFO size
#define kACG_INFO_MAX_FOUND_UNSORTED_RAW_CGS_16K        (16384)                                 // 128K AFW FIFO size

typedef struct kAcgInfoClass
{
    kAlgInfoClass base; 
    kBool isRowBased;
    k32u edgeThreshold; 
    k32u minEdgeThreshold; 
    k32u maxEdgeThreshold;
    k32u widthIntensityThreshold;
    kBool hasWidthIntensityThreshold; 
    k32u minWidth; 
    k32u maxWidth; 
    k32u widthLimit; 
    k32u minSum; 
    k32u maxFound; 
    k32u edgeWindow; 
    kBool hasEdgeWindow;
    k32u minEdgeWindow; 
    k32u maxEdgeWindow; 
    k32u edgeWindowGranularity;
    k32u cgScaleShift; 
    kAcgSpotFormat spotFormat; 
    kAcgSpotFormat spotFormatOptions; 
    kBool entryDebounceEnabled; 
    kBool hasEntryDebounce; 
    k32u exitIntensityThreshold; 
    kBool hasExitIntensityThreshold; 
    kBool requiresScaleFactor;
    kBool rangesEnabled;
    kBool rangeSlicesEnabled;
    kBool spotSortEnabled;
    kBool spotSortInvert;
    kCameraSpotSort spotSortType;
    kCameraCapability capabilities;
    kBool resampleEnabled;
    kBool resamplePreferHigh;
    k32s resampleBegin;
    k32u resampleCount;
    k32u resampleStep;
    k32u resampleStepThreshold;
    k32s resampleZMin;
    k32s resampleZMax;
} kAcgInfoClass; 

kDeclareClassEx(kFs, kAcgInfo, kAlgInfo)

kFsFx(kStatus) kAcgInfo_Init(kAcgInfo info, kType type, kCameraCapability capabilities, k32u plConfig, kVersion plVersion, kAlloc alloc); 
kFsFx(kStatus) kAcgInfo_VRelease(kAcgInfo info); 

kFsFx(kStatus) kAcgInfo_VClone(kAcgInfo info, kAcgInfo other, kAlloc valueAlloc, kObject context); 

kFsFx(kStatus) kAcgInfo_VToRegisters(kAcgInfo info, k32u* reg, kSize capacity, kSize* used, kSize activePipeCount, 
        kSize imageWidth, kSize imgXSubShift, kSize plXSubShift, kSize imageHeight, kSize imgYSubShift, kSize plYSubShift);
kFsFx(kStatus) kAcgInfo_VRead(kAcgInfo info, kXml xml, kXmlItem item); 
kFsFx(kStatus) kAcgInfo_VWrite(kAcgInfo info, kXml xml, kXmlItem item); 
kFsFx(kStatus) kAcgInfo_VVerify(kAcgInfo info);
kFsFx(kCameraAlgorithm) kAcgInfo_VId(kAcgInfo info); 
kFsFx(kType) kAcgInfo_VItemType(kAcgInfo info); 
kFsFx(kSize) kAcgInfo_VItemCount(kAcgInfo info); 
kFsFx(kBool) kAcgInfo_VEquals(kAcgInfo info, kAcgInfo info1);

kFsFx(kStatus) kAcgInfo_Read(kAcgInfo info, kXml xml, kXmlItem item);
kFsFx(kStatus) kAcgInfo_Write(kAcgInfo info, kXml xml, kXmlItem item);

kFsFx(kStatus) kAcgInfo_SetEdgeThreshold(kAcgInfo info, k32u threshold, kAdjust adjustment = kADJUST_NONE); 
kFsFx(k32u) kAcgInfo_EdgeThreshold(kAcgInfo info); 
kFsFx(kStatus) kAcgInfo_EdgeThresholdInfo(kAcgInfo info, kInfo32u* info32u); 

kFsFx(kStatus) kAcgInfo_SetWidthIntensityThreshold(kAcgInfo info, k32u threshold, kAdjust adjustment = kADJUST_NONE); 
kFsFx(k32u) kAcgInfo_WidthIntensityThreshold(kAcgInfo info); 
kFsFx(kStatus) kAcgInfo_WidthIntensityThresholdInfo(kAcgInfo info, kInfo32u* info32u); 

kFsFx(kStatus) kAcgInfo_SetMinWidth(kAcgInfo info, k32u minWidth, kAdjust adjustment = kADJUST_NONE); 
kFsFx(k32u) kAcgInfo_MinWidth(kAcgInfo info); 
kFsFx(kStatus) kAcgInfo_MinWidthInfo(kAcgInfo info, kInfo32u* info32u); 

kFsFx(kStatus) kAcgInfo_SetMaxWidth(kAcgInfo info, k32u maxWidth, kAdjust adjustment = kADJUST_NONE); 
kFsFx(k32u) kAcgInfo_MaxWidth(kAcgInfo info); 
kFsFx(kStatus) kAcgInfo_MaxWidthInfo(kAcgInfo info, kInfo32u* info32u); 

kFsFx(kStatus) kAcgInfo_SetMinSum(kAcgInfo info, k32u minSum, kAdjust adjustment = kADJUST_NONE); 
kFsFx(k32u) kAcgInfo_MinSum(kAcgInfo info); 
kFsFx(kStatus) kAcgInfo_MinSumInfo(kAcgInfo info, kInfo32u* info32u); 

kFsFx(kStatus) kAcgInfo_SetMaxFound(kAcgInfo info, k32u maxFound, kAdjust adjustment = kADJUST_NONE); 
kFsFx(k32u) kAcgInfo_MaxFound(kAcgInfo info); 
kFsFx(kStatus) kAcgInfo_MaxFoundInfo(kAcgInfo info, kInfo32u* info32u); 

kFsFx(kStatus) kAcgInfo_SetEdgeWindow(kAcgInfo info, k32u width, kAdjust adjustment = kADJUST_NONE);
kFsFx(k32u) kAcgInfo_EdgeWindow(kAcgInfo info);
kFsFx(kStatus) kAcgInfo_EdgeWindowInfo(kAcgInfo info, kInfo32u* info32u);

kFsFx(kStatus) kAcgInfo_EnableSpotSort(kAcgInfo info, kBool enabled);
kFsFx(kBool) kAcgInfo_SpotSortEnabled(kAcgInfo info);
kFsFx(kStatus) kAcgInfo_SpotSortEnabledInfo(kAcgInfo info, kInfoBool* infoBool);

kFsFx(kStatus) kAcgInfo_InvertSpotSort(kAcgInfo info, kBool invert);
kFsFx(kBool) kAcgInfo_SpotSortInverted(kAcgInfo info);
kFsFx(kStatus) kAcgInfo_InvertSpotSortInfo(kAcgInfo info, kInfoBool* infoBool); 

kFsFx(kStatus) kAcgInfo_SetSpotSortType(kAcgInfo info, kCameraSpotSort type);
kFsFx(kCameraSpotSort) kAcgInfo_SpotSortType(kAcgInfo info);
kFsFx(kStatus) kAcgInfo_SpotSortTypeInfo(kAcgInfo info, kInfo32u* info32u); 

kFsFx(kStatus) kAcgInfo_SetSpotFormat(kAcgInfo info, kAcgSpotFormat format);
kFsFx(kAcgSpotFormat) kAcgInfo_SpotFormat(kAcgInfo info);
kFsFx(kStatus) kAcgInfo_SpotFormatInfo(kAcgInfo info, kInfoBits* infoBits);

kFsFx(kStatus) kAcgInfo_EnableEntryDebounce(kAcgInfo info, kBool enabled);
kFsFx(kBool) kAcgInfo_EntryDebounceEnabled(kAcgInfo info);
kFsFx(kStatus) kAcgInfo_EntryDebounceEnabledInfo(kAcgInfo info, kInfoBool* infoBool);

kFsFx(kStatus) kAcgInfo_SetExitIntensityThreshold(kAcgInfo info, k32u threshold, kAdjust adjustment = kADJUST_NONE); 
kFsFx(k32u) kAcgInfo_ExitIntensityThreshold(kAcgInfo info); 
kFsFx(kStatus) kAcgInfo_ExitIntensityThresholdInfo(kAcgInfo info, kInfo32u* info32u);

kFsFx(kStatus) kAcgInfo_CalculateRangesSpotCapacity(kAcgInfo info, k32u plConfig, kVersion plVersion, k32u* spotCapacity);

kFsFx(k32s) kAcgInfo_ResampleEnd(kAcgInfo info);

kFsFx(kStatus) kAcgInfo_MaxResampleCount(kAcgInfo info, k32u* maxResamplePoints);

// Helper methods used to implement deprecated methods in child classes; remove 
// when no longer needed by child classes
kFsFx(kStatus) kAcgInfo_SetOutputStage(kAcgInfo info, k32u outputStage);
kFsFx(k32u) kAcgInfo_OutputStage(kAcgInfo info);
kFsFx(kStatus) kAcgInfo_OutputStageInfo(kAcgInfo info, kInfo32u* info32u);

#endif
