/** 
 * @file    kLc250xFpnBlock.x.h
 *
 * @internal
 * Copyright (C) by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_FIRESYNC_LC250X_FPN_BLOCK_X_H
#define K_FIRESYNC_LC250X_FPN_BLOCK_X_H

#include <kFireSync/Pipe/kPxBlock.h>

typedef struct kLc250xFpnBlockClass
{
    kPxBlockClass base; 
    kLc250xFpnBlockInfo info;       //Settings.
    kPxPort outputPort;
    kPxPort hfpnCoefPort;
    kImage vfpnCoef;
    kSize frameCount;
    kBool calibrationEnabled;
    kBool obColRecorded;

} kLc250xFpnBlockClass; 

kDeclareClassEx(kFs, kLc250xFpnBlock, kPxBlock)

kFsFx(const kChar*) kLc250xFpnBlock_VDescription(); 

kFsFx(kStatus) kLc250xFpnBlock_VOnSetup(kLc250xFpnBlock block);
kFsFx(kStatus) kLc250xFpnBlock_VOnStart(kLc250xFpnBlock block);
kFsFx(kStatus) kLc250xFpnBlock_VOnStop(kLc250xFpnBlock block);
kFsFx(kStatus) kLc250xFpnBlock_VOnReceive(kLc250xFpnBlock block, kPxPort port, kMsgSet msg);

kFsFx(kStatus) kLc250xFpnBlock_Calibration(kLc250xFpnBlock block, kImage input, k32u mode);

kFsFx(kStatus) kLc250xFpnBlock_CreateFpnImage(kLc250xFpnBlock block, kImage input, kImage* fpnImage);
kFsFx(kStatus) kLc250xFpnBlock_CreateOutputImage(kLc250xFpnBlock block, kImage fpnImage, kImage* output);
kFsFx(kStatus) kLc250xFpnBlock_HFpnCorrection(kLc250xFpnBlock block, kImage input, kImage fpnImage, kArray1 hfpnCoef);
kFsFx(kStatus) kLc250xFpnBlock_VFpnCorrection(kLc250xFpnBlock block, kImage fpnImage);

#endif
