#ifndef GV_GENERIC_MSG_X_H
#define GV_GENERIC_MSG_X_H

#include <GoVision/GvDef.h>
#include <GoVision/GvUtils.h>
#include <kFireSync/Data/kMsgSet.h>
#include <kFireSync/Data/kProfileMsg.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArrayList.h>

// This header structure prepends the data stored in the message
typedef struct GvGenericMsgDataHeader
{
    k32u isKObject;
    k32u dataSize;
} GvGenericMsgDataHeader;

typedef struct GvGenericMsgClass
{
    GvDataMsgClass base;
} GvGenericMsgClass; 

kDeclareClassEx(Gv, GvGenericMsg, GvDataMsg)

GvFx(kStatus) GvGenericMsg_Construct(GvGenericMsg* msg, kBool isObject, kSize bufferSize, kAlloc alloc);

GvFx(kStatus) GvGenericMsg_Init(GvGenericMsg msg, kType type, kBool isObject, kSize bufferSize, kAlloc allocator);
GvFx(kStatus) GvGenericMsg_VInitClone(GvGenericMsg msg, GvGenericMsg src, kAlloc alloc);
GvFx(kStatus) GvGenericMsg_VRelease(GvGenericMsg msg);

GvFx(kStatus) GvGenericMsg_WriteDat6V0(GvGenericMsg msg, kSerializer serializer);
GvFx(kStatus) GvGenericMsg_WriteHeader(GvGenericMsg msg, kSerializer serializer);
GvFx(kStatus) GvGenericMsg_ReadDat6V0(GvGenericMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvGenericMsg_ReadHeader(GvGenericMsg msg, kSerializer serializer, kBool* isObject, kSize* bufferSize);

GvFx(k64u) GvGenericMsg_TimeAt(GvGenericMsg msg, kSize frame);
GvFx(kStatus) GvGenericMsg_SetTimeAt(GvGenericMsg msg, kSize frame, k64u time);

GvFx(k64s) GvGenericMsg_EncoderAt(GvGenericMsg msg, kSize frame);
GvFx(kStatus) GvGenericMsg_SetEncoderAt(GvGenericMsg msg, kSize frame, k64s encoder);

#endif
