#ifndef GV_FEATURE_MSG_X_H
#define GV_FEATURE_MSG_X_H

#include <GoVision/GvDef.h>
#include <GoVision/GvUtils.h>
#include <GoVision/Data/GvFeature.h>
#include <kFireSync/Data/kMsgSet.h>

typedef struct GvFeatureMsgClass
{
    GvDataMsgClass base;
} GvFeatureMsgClass; 

typedef struct GvFeatureMsgHeader
{
    kSize count;
    kType stampType;
    kTypeVersion stampVersion;
} GvFeatureMsgHeader;

kDeclareClassEx(Gv, GvFeatureMsg, GvDataMsg)

typedef k32s GvFeatureMsg_PoseId;

GvFx(kStatus) GvFeatureMsg_Construct(GvFeatureMsg* msg, GvFeatureType featureType, kSize count, kAlloc alloc);

GvFx(kStatus) GvFeatureMsg_Init(GvFeatureMsg msg, kType type, kSize count, GvFeatureType featureType, kAlloc allocator);
GvFx(kStatus) GvFeatureMsg_VInitClone(GvFeatureMsg msg, GvFeatureMsg src, kAlloc alloc);
GvFx(kStatus) GvFeatureMsg_VRelease(GvFeatureMsg msg);
GvFx(kStatus) GvFeatureMsg_VDataAt(GvFeatureMsg msg, kSize index, kArrayList* list);

GvFx(kStatus) GvFeatureMsg_WriteHeaders(GvFeatureMsg msg, kSerializer serializer, GvFeatureMsgHeader* header);
GvFx(kStatus) GvFeatureMsg_WriteAttrs(GvFeatureMsg msg, kSerializer serializer, const GvFeatureMsgHeader* header);
GvFx(kStatus) GvFeatureMsg_WriteSimple(GvFeatureMsg msg, kSerializer serializer);

GvFx(kStatus) GvFeatureMsg_ReadHeaders(GvFeatureMsg msg, kSerializer serializer, GvFeatureMsgHeader* header);
GvFx(kStatus) GvFeatureMsg_ReadAttrs(GvFeatureMsg msg, kSerializer serializer, const GvFeatureMsgHeader* header);
GvFx(kStatus) GvFeatureMsg_ReadBody(GvFeatureMsg msg, kSerializer serializer, const GvFeatureMsgHeader* header);

GvFx(const kPoint3d64f*) GvFeatureMsg_OffsetAt(GvFeatureMsg msg, kSize frame);
GvFx(kStatus) GvFeatureMsg_SetOffsetAt(GvFeatureMsg msg, kSize frame, const kPoint3d64f* offset);

GvFx(const kPoint3d64f*) GvFeatureMsg_ScaleAt(GvFeatureMsg msg, kSize frame);
GvFx(kStatus) GvFeatureMsg_SetScaleAt(GvFeatureMsg msg, kSize frame, const kPoint3d64f* scale);

GvFx(k64u) GvFeatureMsg_TimeAt(GvFeatureMsg msg, kSize frame);
GvFx(kStatus) GvFeatureMsg_SetTimeAt(GvFeatureMsg msg, kSize frame, k64u time);

GvFx(k64s) GvFeatureMsg_EncoderAt(GvFeatureMsg msg, kSize frame);
GvFx(kStatus) GvFeatureMsg_SetEncoderAt(GvFeatureMsg msg, kSize frame, k64s encoder);

GvFx(kStatus) GvFeatureMsg_AddPoseAt(GvFeatureMsg msg, kSize frame, const kPose2d64f* pose, GvFeatureMsg_PoseId id);
GvFx(kStatus) GvFeatureMsg_SelectPoseAt(GvFeatureMsg msg, kSize frame, GvFeatureMsg_PoseId toId, kPose2d64f* pose);
GvFx(kStatus) GvFeatureMsg_SelectPoseInverseAt(GvFeatureMsg msg, kSize frame, GvFeatureMsg_PoseId fromId, kPose2d64f* pose);
GvFx(kStatus) GvFeatureMsg_SelectPoseRelativeAt(GvFeatureMsg msg, kSize frame, GvFeatureMsg_PoseId toId, GvFeatureMsg_PoseId fromId, kPose2d64f* pose);
GvFx(kStatus) GvFeatureMsg_AssignPoseAt(GvFeatureMsg dstMsg, kSize dstFrame, kMsgSet srcMsg, kSize srcFrame, kAlloc allocator);

GvFx(kSize) GvFeatureMsg_PoseCountAt(GvFeatureMsg msg, kSize frame);
GvFx(kStatus) GvFeatureMsg_PoseAt(GvFeatureMsg msg, kSize frame, kSize index, kPose2d64f* pose, GvFeatureMsg_PoseId* id);
GvFx(kStatus) GvFeatureMsg_SetPoseAt(GvFeatureMsg msg, kSize frame, kSize index, kPose2d64f* pose, GvFeatureMsg_PoseId id);

GvFx(kStatus) GvFeatureMsg_SetObjectExtAt(GvFeatureMsg msg, kSize frame, kObject object);
GvFx(kObject) GvFeatureMsg_ObjectExtAt(GvFeatureMsg msg, kSize frame);

GvFx(kStatus) GvFeatureMsg_SetFeatureType(GvFeatureMsg msg, GvFeatureType dataType);
GvFx(GvFeatureType) GvFeatureMsg_Type(GvFeatureMsg msg, kSize frame);
GvFx(const void*) GvFeatureMsg_FeatureAt(GvFeatureMsg msg, kSize frame);
GvFx(kStatus) GvFeatureMsg_SetFeatureAt(GvFeatureMsg msg, kSize frame, const void *feature);
GvFx(GvProtoFeature*) GvFeatureMsg_FeaturePtr(GvFeatureMsg msg);
GvFx(kStatus) GvFeatureMsg_SetPosition(GvFeatureMsg msg, const kPoint3d64f* position);
GvFx(kStatus) GvFeatureMsg_Position(GvFeatureMsg msg, kPoint3d64f* position);
GvFx(kStatus) GvFeatureMsg_SetOrientation(GvFeatureMsg msg, const kPoint3d64f* orientation);
GvFx(kStatus) GvFeatureMsg_Orientation(GvFeatureMsg msg, kPoint3d64f* orientation);
GvFx(kStatus) GvFeatureMsg_SetRadius(GvFeatureMsg msg, k64f radius);
GvFx(k64f) GvFeatureMsg_Radius(GvFeatureMsg msg);

typedef struct GvPointFeatureMsgClass
{
    GvFeatureMsgClass base;
}GvPointFeatureMsgClass;

kDeclareClassEx(Gv, GvPointFeatureMsg, GvFeatureMsg)

GvFx(kStatus) GvPointFeatureMsg_Construct(GvPointFeatureMsg* msg, kSize count, kAlloc alloc);
GvFx(kStatus) GvPointFeatureMsg_Init(GvPointFeatureMsg msg, kType type, kSize count, kAlloc allocator);
GvFx(kStatus) GvPointFeatureMsg_VInitClone(GvPointFeatureMsg msg,  GvPointFeatureMsg source, kAlloc allocator);
GvFx(kStatus) GvPointFeatureMsg_VRelease(GvPointFeatureMsg msg);
GvFx(kStatus) GvPointFeatureMsg_WriteDat6V1(GvPointFeatureMsg msg, kSerializer serializer);
GvFx(kStatus) GvPointFeatureMsg_ReadDat6V1(GvPointFeatureMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvPointFeatureMsg_VDataAt(GvPointFeatureMsg msg, kSize index, kArrayList* list);

typedef struct GvLineFeatureMsgClass
{
    GvFeatureMsgClass base;
}GvLineFeatureMsgClass;

kDeclareClassEx(Gv, GvLineFeatureMsg, GvFeatureMsg)

GvFx(kStatus) GvLineFeatureMsg_Construct(GvLineFeatureMsg* msg, kSize count, kAlloc alloc);
GvFx(kStatus) GvLineFeatureMsg_Init(GvLineFeatureMsg msg, kType type, kSize count, kAlloc allocator);
GvFx(kStatus) GvLineFeatureMsg_VInitClone(GvLineFeatureMsg msg, GvLineFeatureMsg source, kAlloc allocator);
GvFx(kStatus) GvLineFeatureMsg_VRelease(GvLineFeatureMsg msg);
GvFx(kStatus) GvLineFeatureMsg_WriteDat6V1(GvLineFeatureMsg msg, kSerializer serializer);
GvFx(kStatus) GvLineFeatureMsg_ReadDat6V1(GvLineFeatureMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvLineFeatureMsg_VDataAt(GvLineFeatureMsg msg, kSize index, kArrayList* list);

typedef struct GvCircleFeatureMsgClass
{
    GvFeatureMsgClass base;
}GvCircleFeatureMsgClass;

kDeclareClassEx(Gv, GvCircleFeatureMsg, GvFeatureMsg)

GvFx(kStatus) GvCircleFeatureMsg_Construct(GvCircleFeatureMsg* msg, kSize count, kAlloc alloc);
GvFx(kStatus) GvCircleFeatureMsg_Init(GvCircleFeatureMsg msg, kType type, kSize count, kAlloc allocator);
GvFx(kStatus) GvCircleFeatureMsg_VInitClone(GvCircleFeatureMsg msg, GvCircleFeatureMsg source, kAlloc allocator);
GvFx(kStatus) GvCircleFeatureMsg_VRelease(GvCircleFeatureMsg msg);
GvFx(kStatus) GvCircleFeatureMsg_WriteDat6V1(GvCircleFeatureMsg msg, kSerializer serializer);
GvFx(kStatus) GvCircleFeatureMsg_ReadDat6V1(GvCircleFeatureMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvCircleFeatureMsg_VDataAt(GvCircleFeatureMsg msg, kSize index, kArrayList* list);

typedef struct GvPlaneFeatureMsgClass
{
    GvFeatureMsgClass base;
}GvPlaneFeatureMsgClass;

kDeclareClassEx(Gv, GvPlaneFeatureMsg, GvFeatureMsg)

GvFx(kStatus) GvPlaneFeatureMsg_Construct(GvPlaneFeatureMsg* msg, kSize count, kAlloc alloc);
GvFx(kStatus) GvPlaneFeatureMsg_Init(GvPlaneFeatureMsg msg, kType type, kSize count, kAlloc allocator);
GvFx(kStatus) GvPlaneFeatureMsg_VInitClone(GvPlaneFeatureMsg msg, GvPlaneFeatureMsg source, kAlloc allocator);
GvFx(kStatus) GvPlaneFeatureMsg_VRelease(GvPlaneFeatureMsg msg);
GvFx(kStatus) GvPlaneFeatureMsg_WriteDat6V1(GvPlaneFeatureMsg msg, kSerializer serializer);
GvFx(kStatus) GvPlaneFeatureMsg_ReadDat6V1(GvPlaneFeatureMsg msg, kSerializer serializer, kAlloc allocator);
GvFx(kStatus) GvPlaneFeatureMsg_VDataAt(GvPlaneFeatureMsg msg, kSize index, kArrayList* list);

#endif
