/**
 * @file    TestSurfaceConfiguration.x.h
 *
 * Copyright © 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef TOOL_TEST_SURFACE_CONFIGURATION_TOOL_Z_H
#define TOOL_TEST_SURFACE_CONFIGURATION_TOOL_Z_H

#define TEST_SURFACE_CONFIGURATION_TOOL_NAME        "TestSurfaceConfigurationTool"
#define TEST_SURFACE_CONFIGURATION_TOOL_LABEL       "Test Surface Configuration"

typedef enum TestSurfaceConfigurationMeasurement
{
    TEST_SURFACE_CONFIGURATION_RESULT = 0
} TestSurfaceConfigurationMeasurement;

typedef enum TestSurfaceConfigurationOperator
{
    TEST_SURFACE_CONFIGURATION_OPERATOR_SQUARE = 0,
    TEST_SURFACE_CONFIGURATION_OPERATOR_SQRT,
    TEST_SURFACE_CONFIGURATION_OPERATOR_SCALE
} TestSurfaceConfigurationOperator;

typedef struct TestSurfaceConfigurationClass
{
    GdkToolClass base;
    GdkDataSource dataSource;

    kBool useRegion;
    GdkRegion3d64f region;

    k64f inputValue;
    TestSurfaceConfigurationOperator surfaceOperator;
    k64f factor;
    k64f measurementOffset;
} TestSurfaceConfigurationClass;

kDeclareClassEx(Tool, TestSurfaceConfiguration, GdkTool)

ToolFx(kStatus) TestSurfaceConfiguration_VDescribe(GdkToolInfo info);

ToolFx(kStatus) TestSurfaceConfiguration_VInit(TestSurfaceConfiguration tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestSurfaceConfiguration_VRelease(TestSurfaceConfiguration tool);
ToolFx(kStatus) TestSurfaceConfiguration_VUpdateConfig(const GdkToolEnv* env, GdkToolCfg toolConfig);
ToolFx(kStatus) TestSurfaceConfiguration_VStart(TestSurfaceConfiguration tool);
ToolFx(kStatus) TestSurfaceConfiguration_VStop(TestSurfaceConfiguration tool);
ToolFx(kStatus) TestSurfaceConfiguration_OutputValue(GdkToolOutput output, kSize index, k64f value, GdkMeasurementDecision decision, GdkToolCfg config);
ToolFx(kStatus) TestSurfaceConfiguration_VProcess(TestSurfaceConfiguration tool, GdkToolInput input, GdkToolOutput output);

#endif
