#ifndef TEST_GENERIC_INPUT_TOOL_X_H
#define TEST_GENERIC_INPUT_TOOL_X_H

#include <kApi/Data/kBytes.h>
#include <kApi/Data/kArray2.h>

#include <kVision/S3d/kS3dUtilities.h>

#define TEST_GENERIC_INPUT_TOOL_NAME                "TestGenericInput"
#define TEST_GENERIC_INPUT_TOOL_LABEL               "Test Generic Input"

#define TEST_GENERIC_INPUT_INPUT                    "SegmentationInput"
#define TEST_GENERIC_INPUT_INPUT_LABEL              "Segmentation Result"

#define TEST_GENERIC_INPUT_PARAM_INDEX              "SegIndex%d"
#define TEST_GENERIC_INPUT_PARAM_INDEX_LABEL        "Segment %d Index"
#define TEST_GENERIC_INPUT_PARAM_DETAILS            "ShowDetails"
#define TEST_GENERIC_INPUT_PARAM_DETAILS_LABEL      "Show Details"

#define TEST_GENERIC_INPUT_MEASUREMENTS_PARTS       4
#define TEST_GENERIC_INPUT_POINT_COUNT_PER_PART     5

#define TEST_GENERIC_INPUT_MEASUREMENT_X            "XCenter%d"
#define TEST_GENERIC_INPUT_MEASUREMENT_X_LABEL      "X Center %d"
#define TEST_GENERIC_INPUT_MEASUREMENT_Y            "YCenter%d"
#define TEST_GENERIC_INPUT_MEASUREMENT_Y_LABEL      "Y Center %d"
#define TEST_GENERIC_INPUT_MEASUREMENT_WIDTH        "Width%d"
#define TEST_GENERIC_INPUT_MEASUREMENT_WIDTH_LABEL  "Width %d"
#define TEST_GENERIC_INPUT_MEASUREMENT_LENGTH       "Length%d"
#define TEST_GENERIC_INPUT_MEASUREMENT_LENGTH_LABEL "Length %d"

#define TEST_GENERIC_INPUT_FEATURE_CENTER           "Center%d"
#define TEST_GENERIC_INPUT_FEATURE_CENTER_LABEL     "Center %d"

typedef struct TestGenericInputClass 
{
    GdkToolClass base;
    GdkDataSource dataSource;

    kArrayList segIndices;
    kBool showDetails;

} TestGenericInputClass;


kDeclareClassEx(Tool, TestGenericInput, GdkTool)

ToolFx(const kChar*) TestGenericInput_VName();
ToolFx(kStatus) TestGenericInput_VDescribe(GdkToolInfo info);

ToolFx(kStatus) TestGenericInput_VInit(TestGenericInput tool, kType type, kAlloc alloc);
ToolFx(kStatus) TestGenericInput_VRelease(TestGenericInput tool);
ToolFx(kStatus) TestGenericInput_VStart(TestGenericInput tool);
ToolFx(kStatus) TestGenericInput_VStop(TestGenericInput tool);
ToolFx(kStatus) TestGenericInput_VProcess(TestGenericInput tool, GdkToolInput input, GdkToolOutput output);

#endif
