#ifndef GDK_TOOL_OUTPUT_Z_H
#define GDK_TOOL_OUTPUT_Z_H

#include <Gdk/Utils/GdkDataInfo.h>
#include <Gdk/Tools/GdkPointFeature.h>
#include <Gdk/Tools/GdkLineFeature.h>
#include <Gdk/Tools/GdkCircleFeature.h>
#include <Gdk/Tools/GdkPlaneFeature.h>
#include <Gdk/Tools/GdkToolOutput.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kMap.h>
#include <kFireSync/Pipe/kPxBlock.h>

typedef struct GdkToolDiagnosticOutputItem
{
    k32s id;
    kMsgSet msg;

} GdkToolDiagnosticOutputItem;

typedef struct GdkToolMeasurementOutputParams
{
    k64f value;
    GdkMeasurementDecision status;
    kPoint3d64f position;
    GdkGraphic graphic;
    kBool accessMsg;    // indicates that GDK user has decided to utilize the new API message for this measurement
} GdkToolMeasurementOutputParams;

typedef struct GdkToolFeatureOutputParams
{
    GdkFeature feature;
    GdkFeatureDataType dataType;
    GdkGraphic graphic;
    kBool accessMsg;    // indicates that GDK user has decided to utilize the new API message for this feature
} GdkToolFeatureOutputParams;

typedef struct GdkToolToolDataOutputParams
{
    GdkDataType dataType;
    kBool hasIntensity;
} GdkToolToolDataOutputParams;

typedef union GdkOutputParams
{
    GdkToolMeasurementOutputParams mmtParams;
    GdkToolFeatureOutputParams featureParams;
    GdkToolToolDataOutputParams dataOutParams;
} GdkOutputParams;

typedef struct GdkToolOutputItem
{
    GdkToolOutputType outputType;
    k32s id;
    kMsgSet msg;
    GdkOutputParams params;
} GdkToolOutputItem;


typedef struct GdkToolOutputClass
{
    kObjectClass base;

    kMsgSet stampMsg;   // input message fed into the tool
    kArrayList outputItems;
    kArrayList diagnostics;
    kMap measurementIndexMap;
    kMap featureIndexMap;
    kMap toolDataOutputIndexMap;
    kAlloc toolBlockMsgAlloc;   // used for constructing GvDataMsg class objects
} GdkToolOutputClass;

#define GdkToolOutputTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkToolOutput))) return kERROR_UNIMPLEMENTED;}


GdkFx(kStatus) GdkToolOutput_Init(GdkToolOutput output, kType type, kAlloc alloc);
GdkFx(kStatus) GdkToolOutput_VRelease(GdkToolOutput output);

GdkFx(kStatus) GdkToolOutput_Construct(GdkToolOutput* output, kAlloc alloc);

GdkFx(kStatus) GdkToolOutput_Clear(GdkToolOutput output);

GdkFx(kStatus) GdkToolOutput_SetStampMsg(GdkToolOutput output, kMsgSet msg);
GdkFx(kMsgSet) GdkToolOutput_StampMsg(GdkToolOutput output);
GdkFx(kStatus) GdkToolOutput_AddMeasurement(GdkToolOutput output, k32s id);
GdkFx(kStatus) GdkToolOutput_MeasurementCombinedIndex(GdkToolOutput output, kSize index, kSize *combinedIndex);
GdkFx(GvDataMsg) GdkToolOutput_MeasurementMsg(GdkToolOutput output, kSize index);
GdkFx(kBool) GdkToolOutput_MeasurementAccessMsgFlag(GdkToolOutput output, kSize index);
GdkFx(kStatus) GdkToolOutput_SetMeasurementMsg(GdkToolOutput output, kSize index,  GvMeasureMsg msg);

GdkFx(kStatus) GdkToolOutput_AddFeature(GdkToolOutput output, k32s id, k32s type);
GdkFx(kStatus) GdkToolOutput_FeatureCombinedIndex(GdkToolOutput output, kSize index, kSize *combinedIndex);
GdkFx(GvDataMsg) GdkToolOutput_FeatureMsg(GdkToolOutput output, kSize index);
GdkFx(k32s) GdkToolOutput_FeatureType(GdkToolOutput output, kSize index);
GdkFx(k32s) GdkToolOutput_FeatureAccessMsgFlag(GdkToolOutput output, kSize index);
GdkFx(kStatus) GdkToolOutput_SetFeatureMsg(GdkToolOutput output, kSize index,  GvFeatureMsg msg);
GdkFx(kStatus) GdkToolOutput_CombinedIndex(kMap map, kSize index, kSize *combinedIndex);

GdkFx(kStatus) GdkToolOutput_AddDiagnostic(GdkToolOutput output, k32s id);
GdkFx(kMsgSet*) GdkToolOutput_DiagnosticAt(GdkToolOutput output, kSize index);

GdkFx(kStatus) GdkToolOutput_AddToolDataOutput(GdkToolOutput output, k32s id, GdkDataType dataType, kBool hasIntensity);
GdkFx(kStatus) GdkToolOutput_ToolDataOutputCombinedIndex(GdkToolOutput output, kSize index, kSize* combinedIndex);
GdkFx(kMsgSet) GdkToolOutput_ToolDataOutputMsgAt(GdkToolOutput output, kSize index);
GdkFx(kStatus) GdkToolOutput_NullToolDataOutputMsgAt(GdkToolOutput output, kSize index);
GdkFx(GdkDataType) GdkToolOutput_ToolDataOutputDataTypeAt(GdkToolOutput output, kSize index);

GdkFx(k64f) GdkToolOutput_MeasurementValue(GdkToolOutput output, kSize index);
GdkFx(GdkMeasurementDecision) GdkToolOutput_MeasurementStatus(GdkToolOutput output, kSize index);

GdkFx(GdkGraphic) GdkToolOutput_MeasurementRendering(GdkToolOutput output, kSize index);
GdkFx(GdkGraphic) GdkToolOutput_GetMeasurementGraphic(GdkToolOutput output, kSize index);

/**
* Sets the feature rendering at a specified index.
*
* @public               @memberof GdkToolOutput
* @param    output      Output object.
* @param    index       Feature index within the tool.
* @param    graphic     GdkGraphic object (ownership is transferred).
* @return               Operation status.
*/
GdkFx(kStatus) GdkToolOutput_SetFeatureRendering(GdkToolOutput output, kSize index, GdkGraphic graphic);

GdkFx(GdkGraphic) GdkToolOutput_FeatureRendering(GdkToolOutput output, kSize index);
GdkFx(GdkGraphic) GdkToolOutput_GetFeatureGraphic(GdkToolOutput output, kSize combinedIndex);

GdkFx(const kPoint3d64f*) GdkToolOutput_MeasurementResultPosition(GdkToolOutput output, kSize index); 
GdkFx(kStatus) GdkToolOutput_SetBlockMsgAlloc(GdkToolOutput tool, kAlloc alloc);
GdkFx(kSize) GdkToolOutput_OutputCount(GdkToolOutput output);
GdkFx(GdkToolOutputType) GdkToolOutput_OutputType(GdkToolOutput output, kSize index);
GdkFx(kStatus) GdkToolOutput_OutputId(GdkToolOutput output, kSize index);

GdkFx(kStatus) GdkToolOutput_TransferMsgInfo(GdkToolOutput output, GvDataMsg msg);

#endif
