/** 
 * @file    GdkPlaneFeature.x.h
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.
 * Licensed under the MIT License.
 * Redistributed files must retain the above copyright notice.
 */
#ifndef GDK_PLANE_FEATURE_X_H
#define GDK_PLANE_FEATURE_X_H

typedef struct GdkPlaneFeatureClass
{
    GdkFeatureClass base;
} GdkPlaneFeatureClass;

#define GdkPlaneFeatureTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkPlaneFeature))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkPlaneFeature_Construct(GdkPlaneFeature* feature, kAlloc alloc);
GdkFx(kStatus) GdkPlaneFeature_Init(GdkPlaneFeature feature, kType type, kAlloc allocator);
GdkFx(kStatus) GdkPlaneFeature_VRelease(GdkPlaneFeature feature);
GdkFx(kStatus) GdkPlaneFeature_VInitClone(GdkPlaneFeature feature, GdkPlaneFeature source, kAlloc allocator);

#endif
