#ifndef GDK_OUTPUT_INFO_Z_H
#define GDK_OUTPUT_INFO_Z_H

#include <Gdk/Tools/GdkOutputInfo.h>
#include <Gdk/Config/GdkParamsInfo.x.h>

typedef struct GdkOutputInfoClass
{
    kObjectClass base;
    kText256 typeName;
    kText256 label;
    kSize minCount;
    kSize maxCount;
    GdkParamsInfo params;
} GdkOutputInfoClass;

GdkFx(kStatus) GdkOutputInfo_Init(GdkOutputInfo info, kType type, kAlloc alloc);
GdkFx(kStatus) GdkOutputInfo_VInitClone(GdkOutputInfo info, GdkOutputInfo source, kAlloc alloc);
GdkFx(kStatus) GdkOutputInfo_VRelease(GdkOutputInfo info);

GdkFx(kStatus) GdkOutputInfo_Construct(GdkOutputInfo* info, kAlloc alloc);

GdkFx(kStatus) GdkOutputInfo_Assign(GdkOutputInfo info, GdkOutputInfo source);

/**
* Sets the output type name.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @param    name        Type name.
* @return               Operation status.
*/
GdkFx(kStatus) GdkOutputInfo_SetTypeName(GdkOutputInfo info, const kChar* name);

/**
* Returns the output type name.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @return               Type name.
*/
GdkFx(const kChar*) GdkOutputInfo_TypeName(GdkOutputInfo info);

/**
* Sets the output display label.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @param    label       Display label.
* @return               Operation status.
*/
GdkFx(kStatus) GdkOutputInfo_SetLabel(GdkOutputInfo info, const kChar* label);

/**
* Returns the output display label.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @return               Display label.
*/
GdkFx(const kChar*) GdkOutputInfo_Label(GdkOutputInfo info);

/**
* Sets the minimum number of instances within a tool.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @param    count       Minimum instance count.
* @return               Operation status.
*/
GdkFx(kStatus) GdkOutputInfo_SetMinCount(GdkOutputInfo info, kSize count);

/**
* Returns the minimum number of instances within a tool.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @return               Minimum instance count.
*/
GdkFx(kSize) GdkOutputInfo_MinCount(GdkOutputInfo info);

/**
* Sets the maximum number of instances within a tool.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @param    count       Maximum instance count.
* @return               Operation status.
*/
GdkFx(kStatus) GdkOutputInfo_SetMaxCount(GdkOutputInfo info, kSize count);

/**
* Returns the minimum number of instances within a tool.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @return               Maximum instance count.
*/
GdkFx(kSize) GdkOutputInfo_MaxCount(GdkOutputInfo info);

/**
* Returns the schema for the parameters.
*
* @public               @memberof GdkOutputInfo
* @param    info        Info object.
* @return               Params info.
*/
GdkFx(GdkParamsInfo) GdkOutputInfo_Params(GdkOutputInfo info);

#endif
