/**
* @file     GdkGraphicPlane.x.h
*
* @internal
* Copyright (C) 2008-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_RAY_X_H
#define GDK_GRAPHIC_RAY_X_H

#include <kApi/Data/kMath.h>
#include <kApi/Data/kArrayList.h>
#include <Gdk/GdkDef.h>

typedef struct GdkGraphicRayClass
{
    kObjectClass base;
    kPoint3d32f normal;
    k32f width;
    kColor colour;
    kPoint3d32f position;
} GdkGraphicRayClass;

kDeclareClassEx(Gdk, GdkGraphicRay, kObject)

#define GdkGraphicRayTypeCheck(OBJTYPE)     {if (!kObject_Is(OBJTYPE, kTypeOf(GdkGraphicRay))) return kERROR_UNIMPLEMENTED;}

GdkFx(kStatus) GdkGraphicRay_Init(GdkGraphicRay graphic, kType classType, kAlloc allocator);
GdkFx(kStatus) GdkGraphicRay_Release(GdkGraphicRay graphic);

GdkFx(kStatus) GdkGraphicRay_VRelease(GdkGraphicRay graphic);
GdkFx(kStatus) GdkGraphicRay_Serialize(GdkGraphicRay graphic, kSerializer serializer);

#endif
