/**
* @file    GdkGraphicLabel.h
* @brief   Declares the GdkGraphicLabel class.
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef GDK_GRAPHIC_LABEL_H
#define GDK_GRAPHIC_LABEL_H

#include <Gdk/GdkDef.h>

/**
* @class       GdkGraphicLabel
* @extends     kObject
* @ingroup     Gdk-Data
* @brief       Represents a label.
*/
typedef kObject GdkGraphicLabel;

/**
* Constructs a label object.
*
* @public                  @memberof GdkGraphicLabel
* @param   label           Destination for the constructed object handle.
* @param   allocator       Memory allocator (or kNULL for default).
* @return                  Operation status.
*/
GdkFx(kStatus) GdkGraphicLabel_Construct(GdkGraphicLabel* label, kObject allocator);

/**
* Sets the text of a label
*
* @public                   @memberof GdkGraphicLabel
* @param   label            GdkGraphicLabel object.
* @param   text             Pointer to text of the label in UTF-8 character format
* @return                   Operation status.
*/
GdkFx(kStatus)GdkGraphicLabel_SetText(GdkGraphicLabel label, const kChar *text);

/**
* Sets the to the position of the label
*
* @public                   @memberof GdkGraphicLabel
* @param   label            GdkGraphicLabel object.
* @param   position         Pointer to position of label in space coordinates
* @return                   Operation status.
*/
GdkFx(kStatus) GdkGraphicLabel_SetPosition(GdkGraphicLabel label, kPoint3d64f *position);

#include <Gdk/Data/GdkGraphicLabel.x.h>

#endif
