// Generated by CoffeeScript 1.12.7
var depd, deprecate, fs, helpers, request, requestJson, url;

request = require("request");

fs = require("fs");

url = require("url");

depd = require("depd");

deprecate = depd("request-json");

requestJson = module.exports;

requestJson.createClient = function(url, options) {
  if (options == null) {
    options = {};
  }
  return new requestJson.JsonClient(url, options);
};

requestJson.newClient = function(url, options) {
  if (options == null) {
    options = {};
  }
  deprecate("newClient() is deprecated, please use createClient()");
  return requestJson.createClient(url, options);
};

helpers = {
  merge: function(obj1, obj2) {
    var key, result;
    result = {};
    for (key in obj1) {
      result[key] = obj1[key];
    }
    if (obj2 != null) {
      for (key in obj2) {
        result[key] = obj2[key];
      }
    }
    return result;
  },
  buildOptions: function(clientOptions, clientHeaders, host, path, requestOptions) {
    var options;
    if (requestOptions !== {}) {
      options = helpers.merge(clientOptions, requestOptions);
    }
    if ((requestOptions != null) && requestOptions !== {} && requestOptions.headers) {
      options.headers = helpers.merge(clientHeaders, requestOptions.headers);
    } else {
      options.headers = clientHeaders;
    }
    options.uri = url.resolve(host, path);
    return options;
  },
  parseBody: function(error, response, body, callback) {
    var err, msg, parsed;
    if (typeof body === "string" && body !== "") {
      try {
        parsed = JSON.parse(body);
      } catch (error1) {
        err = error1;
        msg = "Parsing error : " + err.message + ", body= \n " + body;
        if (error == null) {
          error = new Error(msg);
        }
        parsed = body;
      }
    } else {
      parsed = body;
    }
    return callback(error, response, parsed);
  }
};

requestJson.JsonClient = (function() {
  function JsonClient(host1, options1) {
    var ref;
    this.host = host1;
    this.options = options1 != null ? options1 : {};
    this.headers = (ref = this.options.headers) != null ? ref : {};
    this.headers['accept'] = 'application/json';
    this.headers['user-agent'] = "request-json/1.0";
  }

  JsonClient.prototype.setBasicAuth = function(username, password) {
    return this.options.auth = {
      user: username,
      pass: password
    };
  };

  JsonClient.prototype.setDigestAuth = function(username, password) {
    return this.options.auth = {
      user: username,
      pass: password,
      sendImmediately: false
    };
  };

  JsonClient.prototype.setToken = function(token) {
    return this.headers["x-auth-token"] = token;
  };

  JsonClient.prototype.setBearerToken = function(token) {
    return this.options.auth = {
      bearer: token
    };
  };

  JsonClient.prototype.handleRequest = function(method, path, json, options, callback, parse) {
    var Promise, opts;
    if (parse == null) {
      parse = true;
    }
    if (typeof options === 'function') {
      if (typeof callback === 'boolean') {
        parse = callback;
      }
      callback = options;
      options = {};
    }
    if (typeof callback !== 'function') {
      Promise = this.getPromise();
      return new Promise((function(_this) {
        return function(resolve, reject) {
          return _this.handleRequest(method, path, json, options, function(err, res, body) {
            if (err) {
              return reject(err);
            }
            return resolve({
              res: res,
              body: body
            });
          }, parse);
        };
      })(this));
    } else {
      opts = helpers.buildOptions(this.options, this.headers, this.host, path, options);
      opts.method = method;
      if (json != null) {
        opts.json = json;
      }
      return request(opts, function(error, response, body) {
        if (parse) {
          return helpers.parseBody(error, response, body, callback);
        } else {
          return callback(error, response, body);
        }
      });
    }
  };

  JsonClient.prototype.get = function(path, options, callback, parse) {
    if (parse == null) {
      parse = true;
    }
    return this.handleRequest('GET', path, null, options, callback);
  };

  JsonClient.prototype.post = function(path, json, options, callback, parse) {
    if (parse == null) {
      parse = true;
    }
    return this.handleRequest('POST', path, json, options, callback, parse);
  };

  JsonClient.prototype.put = function(path, json, options, callback, parse) {
    if (parse == null) {
      parse = true;
    }
    return this.handleRequest('PUT', path, json, options, callback, parse);
  };

  JsonClient.prototype.patch = function(path, json, options, callback, parse) {
    if (parse == null) {
      parse = true;
    }
    return this.handleRequest('PATCH', path, json, options, callback, parse);
  };

  JsonClient.prototype.head = function(path, options, callback) {
    return this.handleRequest('HEAD', path, null, options, callback);
  };

  JsonClient.prototype.del = function(path, options, callback, parse) {
    if (parse == null) {
      parse = true;
    }
    return this.handleRequest('DELETE', path, null, options, callback, parse);
  };

  JsonClient.prototype["delete"] = function(path, options, callback, parse) {
    if (parse == null) {
      parse = true;
    }
    return this.del(path, options, callback, parse);
  };

  JsonClient.prototype.sendFile = function(path, files, data, callback, parse) {
    var att, file, form, i, index, len, req, results;
    if (parse == null) {
      parse = false;
    }
    if (typeof data === "function") {
      callback = data;
      parse = callback;
    }
    req = this.post(path, null, callback, parse);
    form = req.form();
    if (typeof data !== "function") {
      for (att in data) {
        form.append(att, data[att]);
      }
    }
    if (typeof files === "string") {
      return form.append("file", fs.createReadStream(files));
    } else if (!Array.isArray(files)) {
      return form.append("file", files);
    } else {
      index = 0;
      results = [];
      for (i = 0, len = files.length; i < len; i++) {
        file = files[i];
        index++;
        if (typeof file === "string") {
          results.push(form.append("file" + index, fs.createReadStream(file)));
        } else {
          results.push(form.append("file" + index, file));
        }
      }
      return results;
    }
  };

  JsonClient.prototype.putFile = function(path, file, data, callback, parse) {
    var req;
    if (parse == null) {
      parse = false;
    }
    if (typeof data === "function") {
      parse = callback || false;
      callback = data;
    }
    req = this.put(path, null, {}, callback, parse);
    if (typeof file === "string") {
      return fs.createReadStream(file).pipe(req);
    } else if (!Array.isArray(file)) {
      return file.pipe(req);
    }
  };

  JsonClient.prototype.saveFile = function(path, filePath, callback) {
    var stream;
    stream = this.get(path, callback, false);
    return stream.pipe(fs.createWriteStream(filePath));
  };

  JsonClient.prototype.saveFileAsStream = function(path, callback) {
    return this.get(path, callback, false);
  };

  JsonClient.prototype.getPromise = function() {
    var Promise;
    Promise = this.options.Promise || global.Promise;
    if (!Promise) {
      throw new Error("No Promise provided");
    }
    return Promise;
  };

  return JsonClient;

})();
