console.log('Loading modules...');
var Express = require('express');
var Path = require('path')
var Promise = require('bluebird');
var Engine = require('./engine/Engine.js');
var isRunning = require('is-running');

console.log('Loading parameters...');
var args = "";
for (i = 2; i < process.argv.length; i++) {
	args += " " + process.argv[i];
}
console.log('Args...' + args);
var rootDir = getArg('root') || Path.join(__dirname, '../..');
var arch = getArg('arch') || 'win64'; //default win64
var dataDir = getArg('dataDir') || Path.join(rootDir, 'data', 'GoEmulate');
var portBase = Number(getArg('portBase')) || 3190;
var webPort = Number(getArg('webPort')) || 3191;
var healthPort = Number(getArg('healthPort')) || 3192;
var upgradePort = Number(getArg('upgradePort')) || 3193;
var publicDataPort = Number(getArg('publicDataPort')) || 3194;
var privateDataPort = Number(getArg('privateDataPort')) || 3195;
var udpRpcPort = Number(getArg('udpRpcPort')) || 3196;
var isServer = (getArg('isServer') || '1') != '0' ? true : false;
var binDir = Path.join(rootDir, 'bin', arch);
var goEmulatePath = Path.join(binDir, 'GoEmulateNode');
var parentPid = parseInt(getArg('parentPid')) || -1;//defaults to not checking for parent process
var sensorIp = getArg('sensorIp') || '127.0.0.1';
var instanceIndex = isServer != true ? Number(getArg('instanceIndex')) : 0;
var use32Bit = getArg('use32Bit') == '1' ? true : false;

goEmulatePath = getArg('emulator') || goEmulatePath;

console.log('Loading plug-in...');
var GoEmulate = require(goEmulatePath);

console.log('Constructing engine...');
var engine = new Engine(GoEmulate, binDir,
    dataDir,portBase,
    webPort,healthPort, 
    upgradePort,publicDataPort,
    privateDataPort,udpRpcPort,
    isServer, sensorIp,instanceIndex);

engine.load().then(function(){
    var app = Express();

    function redirectHandler(req, res) {
        var redirUrl = engine.getRedirectUrl();

        if (redirUrl == null)
        {
            redirUrl = req.protocol + '://' + req.get('host') +
                req.originalUrl + 'index.html';
        }

        res.redirect(redirUrl);
    }
    
    function getInfoHandler(req, res){
        var version = engine.getInfo();
        res.json(version);
    }

    app.get('/', redirectHandler);

    var API_PREFIX = '/api/1'

    app.get(API_PREFIX + '/info',getInfoHandler);
    
    //DEV ONLY when --dev flag is present.
    if (process.argv.indexOf('--dev') !== -1){
        console.log('[DEV MODE]');
        
        app.use(function(req, res, next) {
            res.header("Access-Control-Allow-Origin", "*");
            res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
            res.header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');

            next();
        });

        app.use(API_PREFIX + '/dev', require('./routers/sessions_dev.js')(engine));
    }
    // *****
    var scenariosRouter = require('./routers/Scenarios.js');
    app.use(API_PREFIX + '/scenarios', scenariosRouter(engine));

    var sessionsRouter = require('./routers/Sessions.js');
    app.use(API_PREFIX + '/sessions', sessionsRouter(engine));

    var webRoot = Path.join(rootDir, 'res/GoEmulate/Server UI');

    app.use('/', Express.static(webRoot));

    app.get('/emulation', function(req, res) {
        var sessionId = req.query.session;
        var file = 'status.html';

        if (sessionId) {
            session = engine.sessions.findSession(sessionId);

            if (session && session.isRunning()) {
                file = 'emulation.html';
            }
        }

        res.sendFile(file, {root: webRoot});
    });

    return new Promise(function(resolve, reject) {
        var listener = app.listen(engine.getServerPort(), engine.getIsServer() ? "0.0.0.0" : sensorIp, function() {
            var serverPort = listener.address().port

            console.log('NodeJs HTTP server started.');
            console.log('  NodeJsHttpPort: ' + serverPort);

            resolve();
        });
    });
}).then(function() {
    console.log('Server started.....');
}).catch(function(err) {
    console.log('Application initialization failed: ' + err);
});


if (parentPid > 0){
    setInterval(function(){
            if (!isRunning(parentPid)){process.exit(1);}
        }, 2000);
}

function getArg(name) {
    for (var i = 0; i < process.argv.length; ++i) {
        if (process.argv[i] == ('--' + name)) {
            var nextIndex = i + 1;

            if (nextIndex < process.argv.length) {
                return process.argv[nextIndex];
            } else {
                return '';
            }
        }
    }

    return null;
}
