var ACTIVITY_WINDOW = 1 * 60;

var SessionLog = function(id, scenarioId) {
    this._id = id;
    this._scenarioId = scenarioId;
    this._events = [];
    this._print = true;
    this._lastActiveTime = null;
    this._isActive = false;

    this.logEvent('create');
};

SessionLog.prototype.setUser = function(ip, userAgent) {
    this._ip = ip;
    this._userAgent = userAgent;
};

SessionLog.prototype.setIp = function(ip) {
    this._ip = ip;
};

SessionLog.prototype.logEvent = function(event, args) {
    this.logEventWithTime(event, Date.now(), args);
};

SessionLog.prototype.updateActivity = function(changed) {
    var now = Date.now();

    if (this._lastActiveTime == null) {
        this._lastActiveTime = now;
        this._isActive = true;
    }

    var lastIsActive = this._isActive;

    if (changed) {
        this._lastActiveTime = now;
        this._isActive = true;
    } else {
        var inactivePeriod = now - this._lastActiveTime;

        if (inactivePeriod > ACTIVITY_WINDOW * 1000) {
            this._isActive = false;
        }
    }

    if (this._isActive != lastIsActive) {
        if (this._isActive) {
            this.logEventWithTime('activated', now);
        } else {
            this.logEventWithTime('deactivated', this._lastActiveTime);
        }
    }
};

SessionLog.prototype.logEventWithTime = function(event, time, args) {
    var entry = {
        time: time,
        event: event,
        args: args
    };

    this._events.push(entry);

    if (this._print) {
        var msg = this._id + ': ' + event
        if (args) {
            msg = msg + ' (' + JSON.stringify(args) + ')';
        }
        console.log(msg);
    }
};

SessionLog.prototype.export = function() {
    var log = {};

    log.id = this._id;
    log.scenarioId = this._scenarioId;
    log.ip = this._ip;
    log.userAgent = this._userAgent;
    log.events = this._events;

    return log;
};

module.exports = SessionLog;
