#ifndef LMITECH_KVISION_STORAGE_INPUT_BLOCK_INFO_H_INCLUDED
#define LMITECH_KVISION_STORAGE_INPUT_BLOCK_INFO_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>
#include <kVision/L3d/kL3dTransform3d.h>

#define kVS_STORAGE_INPUT_LOADER_BLOCK_NAME                 "StorageInputBlock"
#define kVS_STORAGE_INPUT_LOADER_BLOCK_TYPE_NAME            "kVsStorageInputBlock"

#define kVS_STORAGE_INPUT_BLOCK_INDATA_NAME         "InData"
#define kVS_STORAGE_INPUT_BLOCK_OUTData_NAME      "OutData"


typedef enum
{
    kVs_STORAGE_INPUT_BLOCK_INDATA = 0,
    kVs_STORAGE_INPUT_BLOCK_OUTIMAGE0 = 1
} kVsStorageInputBlockPort;
/**
* @class   kVsStorageInputBlockInfo
* @ingroup kVision
* @brief   Settings class for kVsStorageInputBlock
*/
typedef kObject kVsStorageInputBlockInfo;

kVsFx(kStatus) kVsStorageInputBlockInfo_Construct(kVsStorageInputBlockInfo * info);
kVsFx(kStatus) kVsStorageInputBlockInfo_Load(kVsStorageInputBlockInfo * info, kXml xml);
kVsFx(kStatus) kVsStorageInputBlockInfo_Destroy(kVsStorageInputBlockInfo info);
kVsFx(kStatus) kVsStorageInputBlockInfo_Store(kVsStorageInputBlockInfo info, kXml* xml);

kVsFx(kStatus) kVsStorageInputBlockInfo_Read(kVsStorageInputBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kVsStorageInputBlockInfo_Write(kVsStorageInputBlockInfo info, kXml xml, kXmlItem item);

kVsFx(kStatus) kVsStorageInputBlockInfo_SetInputFileName(kVsStorageInputBlockInfo info, const kChar* name);


kVsFx(const kChar*) kVsStorageInputBlockInfo_InputFileName(kVsStorageInputBlockInfo info);

#endif /* #ifndef LMITECH_KVISION_VS_PRNUBLOCKINFO_H_INCLUDED  */
