#ifndef LMITECH_KVISION_VS_RATELIMITBLOCKINFO_H_INCLUDED
#define LMITECH_KVISION_VS_RATELIMITBLOCKINFO_H_INCLUDED 

#include <kVision/L3d/kL3dCommon.h>

#define kVS_RATE_LIMIT_BLOCK_NAME             "Rate_Limit"
#define kVS_RATE_LIMIT_BLOCK_TYPE_NAME        "kVsRateLimitBlock"

#define kVS_RATE_LIMIT_BLOCK_IN_NAME        "In"
#define kVS_RATE_LIMIT_BLOCK_OUT_NAME       "Out"

typedef enum
{
    kVS_RATE_LIMIT_BLOCK_IN = 0,
    kVS_RATE_LIMIT_BLOCK_OUT = 1
} kVsRateLimitBlockPort;

typedef kPointer kVsRateLimitBlockInfo;

kVsFx(kStatus) kVsRateLimitBlockInfo_Construct(kVsRateLimitBlockInfo * info);
kVsFx(kStatus) kVsRateLimitBlockInfo_Load(kVsRateLimitBlockInfo * info, kXml xml);
kVsFx(kStatus) kVsRateLimitBlockInfo_Destroy(kVsRateLimitBlockInfo info);
kVsFx(kStatus) kVsRateLimitBlockInfo_Store(kVsRateLimitBlockInfo info, kXml* xml);

kVsFx(kStatus) kVsRateLimitBlockInfo_Read(kVsRateLimitBlockInfo info, kXml xml, kXmlItem item);
kVsFx(kStatus) kVsRateLimitBlockInfo_Write(kVsRateLimitBlockInfo info, kXml xml, kXmlItem item);

kVsFx(k32u) kVsRateLimitBlockInfo_Divisor(kVsRateLimitBlockInfo info);
kVsFx(kStatus) kVsRateLimitBlockInfo_SetDivisor(kVsRateLimitBlockInfo info, k32u divisor);

#endif /* #ifndef LMITECH_KVISION_VS_RATELIMITBLOCKINFO_H_INCLUDED */
