#ifndef LMITECH_KVISION_VS_DEF_H_INCLUDED
#define LMITECH_KVISION_VS_DEF_H_INCLUDED

#include <float.h>

#define kVS_ID_FACTORY_NAMESPACE        "Keys\\Factory\\"
#define kVS_ID_FINAL_NAMESPACE          "Keys\\Final\\"

#define kVS_SYNTAX_HARDWARE_PART_NUMBER   "HardwarePartNumber"
#define kVS_SYNTAX_PART_NUMBER            "PartNumber"

#define kVS_WIN32                       ((K_WINDOWS) && (K_POINTER_SIZE==4))
#define kVS_X64                         ((K_WINDOWS) && (K_POINTER_SIZE==8))

#define kVS_64F_EPSILON                (DBL_EPSILON)
#define kVS_64F_EQUALS(A,B)            (kAbs_(A-B) <= kAbs_(A+B)*kVS_64F_EPSILON)

#define kVS_NULL_CENTROID               (0)

#define kVS_FROM_DAY_TO_HOUR(DAY)       ((DAY)*24.0)
#define kVS_FROM_DAY_TO_MIN(DAY)        ((DAY)*1440.0)
#define kVS_FROM_DAY_TO_S(DAY)          ((DAY)*86400.0)
#define kVS_FROM_HOUR_TO_DAY(HOUR)      ((HOUR)/24.0)
#define kVS_FROM_HOUR_TO_MIN(HOUR)      ((HOUR)*60.0)
#define kVS_FROM_HOUR_TO_S(HOUR)        ((HOUR)*3600.0)
#define kVS_FROM_MIN_TO_DAY(MIN)        ((MIN)/1440.0)
#define kVS_FROM_MIN_TO_HOUR(MIN)       ((MIN)/60.0)
#define kVS_FROM_MIN_TO_S(MIN)          ((MIN)*60.0)
#define kVS_FROM_S_TO_DAY(S)            ((S)/86400.0)
#define kVS_FROM_S_TO_HOUR(S)           ((S)/3600.0)
#define kVS_FROM_S_TO_MIN(S)            ((S)/60.0)

#define kVS_FROM_NANO_TO_MICRO(U)       ((U)/1000.0)
#define kVS_FROM_NANO_TO_MILLI(U)       ((U)/1000000.0)
#define kVS_FROM_NANO_TO_CENTI(U)       ((U)/10000000.0)
#define kVS_FROM_NANO(U)                ((U)/1000000000.0)
#define kVS_FROM_MICRO_TO_NANO(U)       ((U)*1000.0)
#define kVS_FROM_MICRO_TO_MILLI(U)      ((U)/1000.0)
#define kVS_FROM_MICRO_TO_CENTI(U)      ((U)/100000.0)
#define kVS_FROM_MICRO(U)               ((U)/1000000.0)
#define kVS_FROM_MILLI_TO_NANO(U)       ((U)*1000000.0)
#define kVS_FROM_MILLI_TO_MICRO(U)      ((U)*1000.0)
#define kVS_FROM_MILLI_TO_CENTI(U)      ((U)/10.0)
#define kVS_FROM_MILLI(U)               ((U)/1000.0)
#define kVS_FROM_CENTI_TO_NANO(U)       ((U)*10000000.0)
#define kVS_FROM_CENTI_TO_MICRO(U)      ((U)*100000.0)
#define kVS_FROM_CENTI_TO_MILLI(U)      ((U)*10.0)
#define kVS_FROM_CENTI(U)               ((U)/100.0)
#define kVS_TO_NANO(U)                  ((U)*1000000000.0)
#define kVS_TO_MICRO(U)                 ((U)*1000000.0)
#define kVS_TO_MILLI(U)                 ((U)*1000.0)
#define kVS_TO_CENTI(U)                 ((U)*100.0)

#define kVS_BYTES_TO_MEGABYTES(U)       ((U)/(1048576.0))

#define kVS_FROM_BLOCK_ID_TO_CAMERA_IDX(BLKID, CAMCOUNT) ((BLKID-kBLOCK_ID_CAMERA_BASE)<CAMCOUNT?(BLKID-kBLOCK_ID_CAMERA_BASE):(k32U_NULL))

//typedef enum
//{
//    kVS_CALIBRATION_NO_OBJECT = -1,
//    kVS_CALIBRATION_NO_TARGET = -2,
//    kVS_CALIBRATION_TARGET_CONFIG_ERROR = -3,
//    kVS_CALIBRATION_TARGET_POS_ERROR = -4,
//    kVS_CALIBRATION_NO_REFERENCE_SLOT = -5,
//    kVS_CALIBRATION_NO_TRAVEL_DETECTED = -6
//} kVsCalibrationStatus;

typedef enum
{
    kVS_CALIBRATION_REFERENCE_NONE,
    kVS_CALIBRATION_REFERENCE_BAR
} kVsSystemCalibrationReferenceType;

#include <kVision/Vs/kVsDef.x.h>

#endif /* #ifndef LMITECH_KVISION_VS_DEF_H_INCLUDED */
