#ifndef kVS_ANALOG_ADJUST_ACTION_INFO_H
#define kVS_ANALOG_ADJUST_ACTION_INFO_H

#include <kVision/Common/kVision.h>
#include <kFireSync/Action/kAxAction.h>
#include <kApi/Data/kXml.h>

typedef enum
{
    kVS_ANALOG_ADJUST_ACTION_AUTO = 0,
    kVS_ANALOG_ADJUST_ACTION_DENSE_LUT = 1,
    kVS_ANALOG_ADJUST_ACTION_LINEAR = 2,
    kVS_ANALOG_ADJUST_ACTION_NONE = 3
} kVsAnalogAdjustCorrectionMethod;

/**
* @class       kVsAnalogAdjustActionInfo
* @extends     kObject
* @ingroup     kVision-Vs
* @brief       Class object for the kVsAnalogAdjustActionInfo class.
*/
typedef kObject kVsAnalogAdjustActionInfo;


/**
* Constructs a kVsAnalogAdjustActionInfo object.
*
* @public               @memberof kVsAnalogAdjustActionInfo
* @param   object       Destination for the constructed object handle.
* @param   sensor       The sensor being calibrated.
* @param   sensorId     The sensor SN - Only used for saving.  For loading the value is not used.
* @param   alloc        Memory allocator (or kNULL for default).
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionInfo_Construct(kVsAnalogAdjustActionInfo* object, kAlloc alloc);

/**
* Creates a kVsAnalogAdjustActionInfo object and loads the xml settings into the class.
*
* @public               @memberof kVsAnalogAdjustActionInfo
* @param   info         The kVsAnalogAdjustActionInfo object
* @param   xml          The xml settings for the action.
* @param   alloc        The allocator to use for constructing the class.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionInfo_Load(kVsAnalogAdjustActionInfo* info, kXml xml, kAlloc alloc);

/**
* Creates an xml object and assigns the input parameters to the xml.
*
* @public               @memberof kVsAnalogAdjustActionInfo
* @param   info         The kVsAnalogAdjustActionInfo object
* @param   xml          The xml settings for the action (output).
* @param   alloc        The allocator to use for constructing the xml.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionInfo_Save(kVsAnalogAdjustActionInfo info, kXml* xml, kAlloc alloc);

/**
* Assigns a new value to the kVsAnalogAdjustCorrectionMethod parameter.
* See the kVsAnalogAdjustCorrectionMethod enum for the options.
* Currently there are 4 options, auto, dense look up table (LUT), linear, and none.
* The Dense LUT will use the dense LUT to correct the Analog Output currents.  (this is the new method, should be more accurate)
* The linear method will correct the Analog Output currents using the two points (per channel) in Adjust.xml (this is the old method)
* Auto will use the dense LUT if the AnalogAdjust.kDat file exists, otherwise it will do linear.
* If none is selected, it will clear the calibration.
* 
* Note that these corrections will not be applied until the action is invoked.
* 
* @public               @memberof kVsAnalogAdjustActionInfo
* @param   info         The kVsAnalogAdjustActionInfo object
* @param   option       The new kVsAnalogAdjustCorrectionMethod option.
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionInfo_SetCorrectionMethod(kVsAnalogAdjustActionInfo info, kVsAnalogAdjustCorrectionMethod option);

/**
* Returns the current correction method stored by the kVsAnalogAdjustActionInfo class.  
*
* @public               @memberof kVsAnalogAdjustActionInfo
* @param   info         The kVsAnalogAdjustActionInfo object
* @return               The correction method.
*/
kVsFx(kVsAnalogAdjustCorrectionMethod) kVsAnalogAdjustActionInfo_CorrectionMethod(kVsAnalogAdjustActionInfo info);

/**
* Validates the kVsAnalogAdjustActionInfo class.
*
* @public               @memberof kVsAnalogAdjustActionInfo
* @param   info         The kVsAnalogAdjustActionInfo object
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionInfo_Validate(kVsAnalogAdjustActionInfo info);


/**
* Validates the kVsAnalogAdjustActionInfo class.
*
* @public               @memberof kVsAnalogAdjustActionInfo
* @param   info         The kVsAnalogAdjustActionInfo object
* @return               Operation status.
*/
kVsFx(kStatus) kVsAnalogAdjustActionInfo_SetDefaults(kVsAnalogAdjustActionInfo info);

#include <kVision/Vs/kVsAnalogAdjustActionInfo.x.h>


#endif
