/**
* @file    kS3dVolumeCheckSparkAlg.x.h
* @brief   Declares the kS3dVolumeCheckSparkAlg class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKSPARK_X_H
#define KVISION_KS3D_VOLUMECHECKSPARK_X_H

typedef struct kS3dVolumeCheckSparkAlgClass
{
    kObjectClass base;

    kPoint3d64f center;        
    k64f polarAngle;    
    k64f slopeAngle;    
    k64f diameter;      
    k8u  segmentBit;
    kBool softCover;
    k64f xyScale;
    k64f zResolution;
    kArray2 holeMap;
    k32s startX;
    k32s endX;
    k32s startY;
    k32s endY;
    k32s outputSizeX;
    k32s outputSizeY;
    k32s lineLen;
    k32s lineCount;
    k32s zmin, zmax;
    k32s holeCount;
    kBool holeExists;
    k32s x0, y0, z0;
    k32s a, b;
    k64f af, bf;
    k32s measureIndex;
    k32s R2;
    k32s RMax2;
} kS3dVolumeCheckSparkAlgClass;

kDeclareClassEx(kVs, kS3dVolumeCheckSparkAlg, kObject)

kStatus kS3dVolumeCheckSparkAlg_Init(kS3dVolumeCheckSparkAlg spark, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckSparkAlg_VRelease(kS3dVolumeCheckSparkAlg spark);
kStatus kS3dVolumeCheckSparkAlg_CreateLittleInclinedHoleMap(kS3dVolumeCheckSparkAlg spark);
kStatus kS3dVolumeCheckSparkAlg_SetAreaMinimum(kS3dVolumeCheckSparkAlg spark, kArray2 output, kArray2 valid);
kStatus kS3dVolumeCheckSparkAlg_FillSparkArea(kS3dVolumeCheckSparkAlg spark, kArray2 output, kArray2 valid);

#define KS3DVOLUMECHECKSPARK(HANDLE) ((kS3dVolumeCheckSparkAlgClass*)(HANDLE))

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKSPARK_X_H */
