/**
* @file    kS3dVolumeCheckPlotter.x.h
* @brief   Declares the kS3dVolumeCheckPlot class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKPLOTTER_X_H
#define KVISION_KS3D_VOLUMECHECKPLOTTER_X_H

#define kS3DVOLUMCHECKER_DEFAULT_PLATTE_POINT_COUNT (9)
#define kS3DVOLUMCHECKER_PLATTE_ARRAY_COUNT (256)


typedef struct kS3dVolumeCheckPlotterClass
{
    kObjectClass base;
    kArray1 palArray;
    k32s imageSizeX;
    k32s imageSizeY;
    kPoint3d64f scale;
    kImage  viewImage; 
    kImage  scaleImage; 
    kText32 zUnit;
    kText32 outUnit;
    k16s scaleCount;
    k64f viewMin;
    k64f viewMax;
    k64f zMin;
    k64f zMax;
    k64f scaleMin;
    k64f step;
    kBool drawScale;
}kS3dVolumeCheckPlotterClass;


kDeclareClassEx(kVs, kS3dVolumeCheckPlotter, kObject)

kStatus kS3dVolumeCheckPlotter_Init(kS3dVolumeCheckPlotter plotter, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckPlotter_VRelease(kS3dVolumeCheckPlotter plotter);
kStatus kS3dVolumeCheckPlotter_SetArgbValue(kArgb* rgbColor, k32u value);
kStatus kS3dVolumeCheckPlotter_SetViewScale(kS3dVolumeCheckPlotter plotter);
kStatus kS3dVolumeCheckPlotter_SetViewDepthRange(kS3dVolumeCheckPlotter plotter, kArray2 data);
kStatus kS3dVolumeCheckPlotter_SetDefaultDepthImagePal(kS3dVolumeCheckPlotter plotter);

#define kS3DVOLUMECHECKPLOTTER(HANDLE) ((kS3dVolumeCheckPlotterClass*)(HANDLE))

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKPLOTTER_X_H */
