/**
* @file    kS3dVolumeCheckInputAlg.x.h
* @brief   Declares the kS3dVolumeCheckInputAlg class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_S3D_VOLUMECHECKINPUTALG_X_H
#define KVISION_S3D_VOLUMECHECKINPUTALG_X_H

typedef struct kS3dVolumeCheckInputAlgClass
{
    kObjectClass base;

    kPoint3d64f position;
    kPoint3d64f orientation;
    kPoint3d64f randomPosition;
    kPoint3d64f randomOrientation;
    kPoint3d64f inputScale;
    kPoint3d64f actualScale;
    k32s dataTypeIndex;
    k32s startIndex;
    k32s measurementCount;
    kBool randomUsed;
    kBool saveSimulation;
    k32u chamberType;

    kType dataType;
    kText256 fileName;
    k32s fileCount;
    k32u measureIndex;
    k32u fileIndex;
    kS3dTransform6fd pos;
    kText64 inputName;
    kBool infoExists;
}kS3dVolumeCheckInputAlgClass;


kDeclareClassEx(kVs, kS3dVolumeCheckInputAlg, kObject)

kStatus kS3dVolumeCheckInputAlg_Init(kS3dVolumeCheckInputAlg inputAlg, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckInputAlg_VRelease(kS3dVolumeCheckInputAlg inputAlg);
kVsFx(kStatus) kS3dVolumeCheckInputAlg_LoadInput3DArray(kS3dVolumeCheckInputAlg inputAlg, kArray2* data);
kVsFx(kStatus) kS3dVolumeCheckInputAlg_LoadInputOmc(kS3dVolumeCheckInputAlg inputAlg, kArray2* data);
kVsFx(kStatus) kS3dVolumeCheckInputAlg_SaveSimulationInputArray(kS3dVolumeCheckInputAlg inputAlg, kArray2 inputData);
kStatus kS3dVolumeCheckInputAlg_ReadSimulationInputOmc(kS3dVolumeCheckInputAlg inputAlg, kArray2* data);
kStatus  kS3dVolumeCheckInputAlg_SetSimulationFileName(kS3dVolumeCheckInputAlg inputAlg);
kStatus kS3dVolumeCheckInputAlg_LoadSimulationInputInfo(kS3dVolumeCheckInputAlg inputAlg);

#define kS3DVOLUMECHECKINPUTALG(HANDLE)           ((kS3dVolumeCheckInputAlgClass*)(HANDLE))
        

#endif  /* #ifndef KVISION_S3D_VOLUMECHECKINPUTALG_X_H */  
