#ifndef LMITECH_KVISION_S3D_STEREOTRACEALG_H_INCLUDED
#define LMITECH_KVISION_S3D_STEREOTRACEALG_H_INCLUDED

#include <kVision/S3d/kS3dStereoCal.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/S3d/kS3dCommon.h>
#include <kVision/S3d/kS3dStereoProfiler.h>
#include <kFireSync/Data/kPlot.h>

typedef kPointer kS3dStereoTraceAlg;

typedef struct kS3dStereoTraceAlgParams 
{
    kRect3d64f fov;
    k64f rangeResolution;

} kS3dStereoTraceAlgParams;

kVsFx(kStatus) kS3dStereoTraceAlg_Construct(kS3dStereoTraceAlg* alg, const kS3dStereoTraceAlgParams* params, kS3dStereoCal cal);
kVsFx(kStatus) kS3dStereoTraceAlg_Destroy(kS3dStereoTraceAlg alg);

kVsFx(kSize) kS3dStereoTraceAlg_WorldLutWidth(kS3dStereoTraceAlg alg);
kVsFx(kSize) kS3dStereoTraceAlg_WorldLutHeight(kS3dStereoTraceAlg alg);
kVsFx(kSize) kS3dStereoTraceAlg_WorldLutDepth(kS3dStereoTraceAlg alg);

kVsFx(kStatus) kS3dStereoTraceAlg_ImagePlot(kS3dStereoTraceAlg alg, kSize sliceIndex, kPlot* plot);

kVsFx(kStatus) kS3dStereoTraceAlg_EvaluateImage(kS3dStereoTraceAlg alg, kSize viewIndex, const kPoint3d64f* worldPoints, kSize count, kPoint64f* imagePoints);
kVsFx(kStatus) kS3dStereoTraceAlg_EvaluateRay(kS3dStereoTraceAlg alg, kSize viewIndex, const kPoint64f* imagePoint, kPoint3d64f* rayPoint, kPoint3d64f* rayDir);

kVsFx(kS3dStereoProfiler) kS3dStereoTraceAlg_Profiler(kS3dStereoTraceAlg alg);

kVsFx(kStatus) kS3dStereoTraceAlg_LookupDisparitySpots(kS3dStereoTraceAlg alg, kS3dStripeSpot* spots0, kS3dStripeSpot* spots1, kSize count, kPoint3d16s* output);

#endif /* #define LMITECH_KVISION_S3D_STEREOTRACEALG_H_INCLUDED */
