/**
* @file    kS3dStereoProfilerHost.h
* @brief   Declares the kS3dStereoProfilerHost class.
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_VISION_S3D_STEREO_PROFILER_HOST_H
#define K_VISION_S3D_STEREO_PROFILER_HOST_H

#include <kVision/S3d/kS3dStereoProfilerBase.h>

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

/**
* @class       kS3dStereoProfilerHost
* @extends     kObject
* @ingroup     kVision-S3d
* @brief       Performs 3D point generation. This is a CPU implementation of the stereo profiler class
*              Inherits from kS3dStereoProfilerBase 
*              Brother class to kS3dStereoProfilerCuda
*/
typedef kObject kS3dStereoProfilerHost;

/**
* Constructs a kS3dStereoProfilerHost object
*
* @public              @memberof kS3dStereoProfilerHost
* @param   profiler    Profiler object
* @param   params      Profiler params
* @param   cal         Stereo calibration object
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/
kVsFx(kStatus) kS3dStereoProfilerHost_Construct(kS3dStereoProfilerHost* profiler, const kS3dStereoProfilerParams* params, kS3dStereoCal cal, kAlloc alloc);


//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#include <kVision/S3d/kS3dStereoProfilerHost.x.h>

#endif // K_VISION_S3D_STEREO_PROFILER_HOST_H
