/**
* @file    kS3dStereoProfilerCuda.x.h
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_VISION_S3D_STEREO_PROFILER_CUDA_X_H
#define K_VISION_S3D_STEREO_PROFILER_CUDA_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dStereoProfilerCudaClass
{
    kS3dStereoProfilerBaseClass base;

    // Disparity lookup //////////////////////////////////////////////////
    kS3dStereoProfilerLutParams3d* cudaDisparityLutParams;
    kArray3 cudaDisparityLut;

    // Phase lookup //////////////////////////////////////////////////////
    kS3dStereoProfilerLutParams3d* cudaPhaseLutParams;
    kArray3 cudaPhaseLut[2];
       
    // Rectification /////////////////////////////////////////////////////
    kS3dStereoProfilerLutParams2d* cudaRectLutParams;
    kArray2 cudaRectLut[2];

    kS3dStereoProfilerHwContext cudaHwContext;

} kS3dStereoProfilerCudaClass;

kDeclareClassEx(kVs, kS3dStereoProfilerCuda, kS3dStereoProfilerBase)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) xkS3dStereoProfilerCuda_Init(kS3dStereoProfilerCuda profiler, const kS3dStereoProfilerParams* params, kS3dStereoCal cal, kAlloc allocator);
kVsFx(kStatus) xkS3dStereoProfilerCuda_VInitClone(kS3dStereoProfilerCuda profiler, kS3dStereoProfilerCuda source, kAlloc allocator);
kVsFx(kStatus) xkS3dStereoProfilerCuda_VRelease(kS3dStereoProfilerCuda profiler);
kVsFx(kSize) xkS3dStereoProfilerCuda_VSize(kS3dStereoProfilerCuda profiler);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif // K_VISION_S3D_STEREO_PROFILER_CUDA_X_H
