/**
* @file    kS3dStereoProfilerCuda.h
* @brief   Declares the kS3dStereoProfilerCuda class.
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_VISION_S3D_STEREO_PROFILER_CUDA_H
#define K_VISION_S3D_STEREO_PROFILER_CUDA_H

#include <kVision/S3d/kS3dStereoProfilerBase.h>

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

/**
* @class       kS3dStereoProfilerCuda
* @extends     kObject
* @ingroup     kVision-S3d
* @brief       Performs 3D point generation. This is a GPU implementation of the stereo profiler class
*              Inherits from kS3dStereoProfilerBase
*              Brother class to kS3dStereoProfilerHost
*/
typedef kObject kS3dStereoProfilerCuda;

/**
* Constructs a kS3dStereoProfilerCuda object
*
* @public              @memberof kS3dStereoProfilerCuda
* @param   profiler    Profiler object
* @param   params      Profiler params
* @param   cal         Stereo calibration object
* @param   allocator   Memory allocator (or kNULL for default).
* @return              Operation status.
*/

kVsFx(kStatus) kS3dStereoProfilerCuda_Construct(kS3dStereoProfilerCuda* profiler, const kS3dStereoProfilerParams* params, kS3dStereoCal cal, kAlloc alloc);

/**
* Acquire hardware context for executing certain profiler functions without the profiler object at hand.
*
* @public              @memberof kS3dStereoProfilerCuda
* @param   profiler    Profiler object
* @return              Pointer to the hardware context object allocated on device.
*/

kVsFx(kS3dStereoProfilerHwContext) kS3dStereoProfilerCuda_HwContextCuda(kS3dStereoProfilerCuda profiler);

/**
*
* Update the window params for each camera.
* Used by rectification.
*
* @public              @memberof kS3dStereoProfiler
* @param   profiler    Profiler object
* @param   window0     Window 0
* @param   window1     Window 1
* @return              Operation status
*
*/

kVsFx(kStatus) kS3dStereoProfilerCuda_UpdateWindow(kS3dStereoProfilerCuda profiler, const kL3dCameraWindow* window0, const kL3dCameraWindow* window1);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#include <kVision/S3d/kS3dStereoProfilerCuda.x.h>

#endif // K_VISION_S3D_STEREO_PROFILER_CUDA_H
