#ifndef LMITECH_KVISION_S3D_ZSTEREOCAL_H_INCLUDED
#define LMITECH_KVISION_S3D_ZSTEREOCAL_H_INCLUDED

//////////////////////////////////////////////////////////////////////////
// Number of cameras used in kS3dStereoCal and kS3dPhaseProcessor
//////////////////////////////////////////////////////////////////////////

#define kS3D_STEREO_CAL_VIEW_COUNT                  (2) 
#define kS3D_STEREO_CAL_VERSION                     (3)

typedef struct kS3dStereoCalClass 
{   
    kS3dStereoCalParams params;

    k32u id;
    kString timestamp;
    k64f temperature;

    kBool invertX[kS3D_STEREO_CAL_VIEW_COUNT];
    kBool invertY[kS3D_STEREO_CAL_VIEW_COUNT];
    kBool transpose[kS3D_STEREO_CAL_VIEW_COUNT];

    kArray2 projectionX0;
    kArray2 projectionY0;
    kArray2 projectionX1;
    kArray2 projectionY1;

    kArray2 disparityMap;
    kArray1 disparityToX;
    kArray1 disparityToY;
    kArray1 disparityToZ;

    kArray2 phaseMap0;
    kArray1 phaseToX0;
    kArray1 phaseToY0;
    kArray1 phaseToZ0;

    kArray2 phaseMap1;
    kArray1 phaseToX1;
    kArray1 phaseToY1;
    kArray1 phaseToZ1;

} kS3dStereoCalClass;

kStatus kS3dStereoCal_Create(kS3dStereoCal* cal);
kStatus kS3dStereoCal_Init(kS3dStereoCal cal,  const kS3dStereoCalParams* params);
kStatus kS3dStereoCal_Release(kS3dStereoCal cal);

kStatus kS3dStereoCal_Read(kS3dStereoCal cal, kDataTree tree, kDataTreeItem item);
kStatus kS3dStereoCal_Write(kS3dStereoCal cal, kDataTree tree, kDataTreeItem item);

//Deprecated; kS3dStereoCal_SetInvertXAt is preferred
kVsFx(kStatus) kS3dStereoCal_SetInvertX0(kS3dStereoCal cal, kBool invertX);

//Deprecated; kS3dStereoCal_InvertXAt is preferred
kVsFx(kBool) kS3dStereoCal_InvertX0(kS3dStereoCal cal);

//Deprecated; kS3dStereoCal_SetInvertYAt is preferred
kVsFx(kStatus) kS3dStereoCal_SetInvertY0(kS3dStereoCal cal, kBool invertY);

//Deprecated; kS3dStereoCal_InvertYAt is preferred
kVsFx(kBool) kS3dStereoCal_InvertY0(kS3dStereoCal cal);

//Deprecated; kS3dStereoCal_InvertXAt is preferred
kVsFx(kStatus) kS3dStereoCal_SetInvertX1(kS3dStereoCal cal, kBool invertX);

//Deprecated; kS3dStereoCal_InvertXAt is preferred
kVsFx(kBool) kS3dStereoCal_InvertX1(kS3dStereoCal cal);

//Deprecated; kS3dStereoCal_InvertYAt is preferred
kVsFx(kStatus) kS3dStereoCal_SetInvertY1(kS3dStereoCal cal, kBool invertY);

//Deprecated; kS3dStereoCal_InvertYAt is preferred
kVsFx(kBool) kS3dStereoCal_InvertY1(kS3dStereoCal cal);

#define kS3D_STEREO_CAL(HANDLE) ((kS3dStereoCalClass*)(HANDLE))

#endif /* #ifndef LMITECH_KVISION_S3D_ZSTEREOCAL_H_INCLUDED */
