#ifndef kS3D_SINGLE_SPHERE_ALG_X_H
#define kS3D_SINGLE_SPHERE_ALG_X_H

#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kImage.h>
#include <kApi/Data/kMath.h>
#include <kVision/Vs/kVsUtilities.h>
#include <kVision/L3d/kL3dPolynomial2Array.h>
#include <kVision/L3d/kL3dChartPlotter.h>
#include <kVision/L3d/kL3dPolynomial2Fit.h>
#include <kVision/S3d/kS3dUtilities.h>

#define kS3D_SINGLE_SPHERE_ALG_DETECT_ITERATION_COUNT  (2)
#define kS3D_SINGLE_SPHERE_ALG_SPHERE_ITERATION_COUNT  (1000)
#define kS3D_SINGLE_SPHERE_ALG_MIN_VALID_POINTS        (100)
#define kS3D_SINGLE_SPHERE_ALG_DEFAULT_MAP_HEIGHT      (3648)   //Defaults for 3504
#define kS3D_SINGLE_SPHERE_ALG_DEFAULT_MAP_WIDTH       (2154)
#define kS3D_SINGLE_SPHERE_ALG_DEFAULT_NOMINAL_RADIUS  (12.7)   // mm
#define kS3D_SINGLE_SPHERE_ALG_DEFAULT_FIT_ORDER       (5)
#define kS3D_SINGLE_SPHERE_ALG_MIN_COVERAGE_FRACTION   (0.125)  // might need to tune this threshold

typedef struct kS3dSingleSphereAlgClass
{
    kObjectClass base;

    kArrayList pointsList;
    kPoint3d64f sphereCenter;
    k64f sphereRadius;
    k64f spatialNoise;
    k64f coverage;
    k64f maxRadialError;
    k64f minRadialError;
    kBool detectionSuccess;
    kArray2 radialErrorMap;
    kArray2 smoothRadialError;
    kSize mapHeight;
    kSize mapWidth;
    kSize fitOrder;

} kS3dSingleSphereAlgClass;

kDeclareClassEx(kVs, kS3dSingleSphereAlg, kObject)

kVsFx(kStatus) kS3dSingleSphereAlg_VRelease(kS3dSingleSphereAlg alg);
kStatus kS3dSingleSphereAlg_Init(kS3dSingleSphereAlg alg, kAlloc allocator);
kStatus kS3dSingleSphereAlg_Release(kS3dSingleSphereAlg alg);
kStatus kS3dSingleSphereAlg_CollectPoints(kS3dSingleSphereAlg alg, kArray2 heightMap);
kStatus kS3dSingleSphereAlg_ValidateHeightMap(kS3dSingleSphereAlg alg, kArray2 heightMap);
kStatus kS3dSingleSphereAlg_DetectBall(kS3dSingleSphereAlg alg, kArray2 heightMap);
kStatus kS3dSingleSphereAlg_CalculateRadialError(kS3dSingleSphereAlg alg, kArray2 heightMap);
kStatus kS3dSingleSphereAlg_CalculateSpatialNoise(kS3dSingleSphereAlg alg, kArray2 heightMap);
kStatus kS3dSingleSphereAlg_CalculateSmoothRadialError(kS3dSingleSphereAlg alg, kArray2 heightMap);
kStatus kS3dSingleSphereAlg_RemoveOutliers(kS3dSingleSphereAlg alg, kArray2 heightMap);
kStatus kS3dSingleSphereAlg_CalculateCoverage(kS3dSingleSphereAlg alg, kArray2 heightMap);

#endif /* #ifndef kS3D_SINGLE_SPHERE_ALG_X_H */
