#ifndef kS3D_SCAN_INPUT_X_H
#define kS3D_SCAN_INPUT_X_H

#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kImage.h>
#include <kVision/Vs/kVsUtilities.h>

typedef struct kS3dScanInputClass
{
    kObjectClass base;

    //attributes

    kSize id;
    kText256 partNumber;
    kText256 timestamp;

    // inputs

    kArrayList inputMessages;
    kArrayList inputSources;

} kS3dScanInputClass;

kDeclareClassEx(kVs, kS3dScanInput, kObject)

kVsFx(kStatus) kS3dScanInput_VRelease(kS3dScanInput scan);
kStatus kS3dScanInput_Init(kS3dScanInput scan, kAlloc allocator);
kStatus kS3dScanInput_Release(kS3dScanInput scan);

kVsFx(kStatus) kS3dScanInput_Read(kS3dScanInput scan, kDataTree tree, kDataTreeItem item);
kVsFx(kStatus) kS3dScanInput_Write(kS3dScanInput scan, kDataTree tree, kDataTreeItem item);

#endif /* #ifndef kS3D_SCAN_INPUT_X_H */
