#ifndef KVISION_S3D_POLYNMAP_X_H
#define KVISION_S3D_POLYNMAP_X_H

typedef struct kS3dPolynomialMapParams
{
    k64f xyScale;
    k64f zScale;
    k32s order;
    k32s order2;
    k32s step;
}kS3dPolynomialMapParams;

//#define kS3DCALIBRATION_PICTURE_MAXCOUNT  (100)

typedef struct kS3dPolynomialMapClass
{
    kObjectClass base;
    kS3dPolynomialMapParams params;
    k32s paraSize;
    k32s matSize;
    k32s potencyLen;

    k32s paraSize2;
    k32s matSize2;
    k32s potencyLen2;

    k32s planeCount;
    k32s imageSizeY;
    k32s imageSizeX;
    k32s polynLineDegree;

    kArray1 indexX;
    kArray1 indexY;
    kArray1 mat;
    kArray1 mat2;
    kArray1 inv;
    kArray1 inv2;
    kArray1 vec;
    kArray1 vec2;
    kArray2 xyValue;
    kArray2 zValue;
    kArray2 linePolyn;
}kS3dPolynomialMapClass;

kDeclareClassEx(kVs, kS3dPolynomialMap, kObject)

kStatus kS3dPolynomialMap_Init(kS3dPolynomialMap polynMap, kType classType, kAlloc alloc);

kVsFx(kStatus) kS3dPolynomialMap_VRelease(kS3dPolynomialMap polynMap);

kStatus kS3dPolynomialMap_CreatePolynMatrix(kS3dPolynomialMap polynMap, kArray2 data, kS3dArray2DataType type);
kStatus kS3dPolynomialMap_CreateMatrixXYPoint3d(kS3dPolynomialMap polynMap, kArray2 data);
kStatus kS3dPolynomialMap_CreateValidPolynMatrix(kS3dPolynomialMap polynMap, kArray2 data, kArray2 valid, k32f weight, kS3dArray2DataType type);
kStatus kS3dPolynomialMap_CreateMatrixFromMapXYZ(kS3dPolynomialMap polynMap, kArray2 mapX, kArray2 mapY, kArray2 data, kArray2 valid);
kStatus kS3dPolynomialMap_CreatePolynomialMatrixFromParaXY(kS3dPolynomialMap polynMap, kArray2 data, kS3dPolynomial polynX, kS3dPolynomial polynY);


kStatus kS3dPolynomialMap_FillPolynomalMatrix(kS3dPolynomialMap polynMap);


kStatus kS3dPolynomialMap_SolveEquations(kS3dPolynomialMap polynMap, kS3dPolynomial polynomial);

kStatus kS3dPolynomialMap_SolveTwoMapEquations(kS3dPolynomialMap polynMap, kS3dPolynomial polynomialX, kS3dPolynomial polynomialY);

kStatus kS3dPolynomialMap_WeightedMapValue(kS3dPolynomialMap polynMap, kArray2 data, kArray2 valid, kS3dPolynomial polynomial, k32f f1, k32f f2, kS3dArray2DataType type);

kStatus kS3dPolynomialMap_DrawDerivativeMap(kS3dPolynomialMap polynMap, kArray2 data, kArray2 valid, kS3dPolynomial polynomial, k32f wavelength, kS3dArray2DataType type);

kStatus kS3dPolynomialMap_DrawValidPolynomal(kS3dPolynomialMap polynMap, kArray2 data, kArray2 valid, kS3dPolynomial polynomial, kS3dArray2DataType type);

kStatus kS3dPolynomialMap_CreateMatrixPolynPoint3d(kS3dPolynomialMap polynMap, kArray1 data);

kStatus kS3dPolynomialMap_CreateMatrixWeightedPoint3d(kS3dPolynomialMap polynMap, kArray2 data);

kStatus kS3dPolynomialMap_CreateValidMatrix(kS3dPolynomialMap polynMap, kArray2 data, kArray2 valid, kS3dArray2DataType type);

kStatus kS3dPolynomialMap_SetMatrixDerivative3order(kS3dPolynomialMap polynMap, kArray2 data, kArray2 valid, kS3dPolynomial polynomial, k32f wavelength, kS3dArray2DataType type);

kVsFx(kStatus) kS3dPolynomialMap_StandardDeviation(kS3dPolynomialMap polynMap, kArray2 data, kArray2 valid,  kS3dPolynomial polynomial, k64f* dev, k32s*validCount,
    kS3dArray2DataType inType, kS3dArray2DataType outType, k32s weight);

kStatus kS3dPolynomialMap_CreateMatrixFromPolynCoord(kS3dPolynomialMap polynMap, kS3dPolynomial polynZ, kS3dPolynomial polynX, kS3dPolynomial polynY, k64f gScale, k32s imageSizeX, k32s imageSizeY);

kStatus kS3dPolynomialMap_CreateMatrixFromGridPoints(kS3dPolynomialMap polynMap, kArray2 data, k64f centerX, k64f centerY);

kStatus kS3dPolynomialMap_SolvePolynMapEquations(kS3dPolynomialMap polynMap, kS3dPolynomial polynomial);
kStatus kS3dPolynomialMap_AddPhaseDistorMatrixItem(kS3dPolynomialMap polynMap, kArray1 viewPoint, kArray1 phaseX);

kStatus kS3dPolynomialMap_DrawPolynMatrixMapFromParaXY(kS3dPolynomialMap polynMap, kArray2 data, kS3dPolynomial polynX, kS3dPolynomial polynY, kS3dPictureInfoItem *picInfo, kBool logDev);
kStatus kS3dPolynomialMap_PolynMapFromZParaXY(kS3dPolynomialMap polynMap, kArray2 data, kS3dPolynomial polynOutX, kS3dPolynomial polynOutY, kS3dPolynomial polynX, kS3dPolynomial polynY, kS3dPictureInfoItem *picInfo, kBool logDev);

#define kS3DPOLYNOMIALMAP(HANDLE) ((kS3dPolynomialMapClass*)(HANDLE))

#endif
