#ifndef kS3D_PHASECODE_MEDIAN_X_H
#define kS3D_PHASECODE_MEDIAN_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_GRAYCODEMEDIAN_DEFAULT_REPEAT 2

#define kS3D_PHASE_MEDIAN(A, B, C)   kClamp_((A), (kMin_((B),(C))), (kMax_((B),(C))))

typedef struct kS3dPhaseMedianClass
{
    kObjectClass base;
    kArray2 temp;
    kArray2 data;
    kVsJobQueue jobQueue;
    k32s repeat;
    k32s imageSizeX;
    k32s imageSizeY;
    k32s phaseWidth;
    k32s width;
} kS3dPhaseMedianClass;

kDeclareClassEx(kVs, kS3dPhaseMedian, kObject)

kVsFx(kStatus) kS3dPhaseMedian_VInitClone(kS3dPhaseMedian median, kS3dPhaseMedian source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseMedian_VRelease(kS3dPhaseMedian median);
kVsFx(kSize)   kS3dPhaseMedian_VSize(kS3dPhaseMedian median);

kStatus kS3dPhaseMedian_Init(kS3dPhaseMedian median, kType classType, kAlloc alloc);

kStatus kS3dPhaseMedian_Row(kS3dPhaseMedian median);
kStatus kCall kS3dPhaseMedian_RowHandler(kS3dPhaseMedian median, k64u id);
kStatus kS3dPhaseMedian_RowThread(kS3dPhaseMedian median, kSize startRow, kSize rowCount);

kStatus kS3dPhaseMedian_Column(kS3dPhaseMedian median);
kStatus kCall kS3dPhaseMedian_ColumnHandler(kS3dPhaseMedian median, k64u id);
kStatus kS3dPhaseMedian_ColumnThread(kS3dPhaseMedian median, kSize startRow, kSize rowCount);

kStatus kS3dPhaseMedian_SetJobQueue(kS3dPhaseMedian median, kVsJobQueue queue);

#endif
