/**
* @file    kS3dPhaseFilter.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef kS3D_PHASE_FILTER_X_H
#define kS3D_PHASE_FILTER_X_H

#include <kVision/Vs/kVsJobQueue.h>

#define kS3D_PHASE_FILTER_DEFAULT_MIN_RUN   (3)
#define kS3D_PHASE_FILTER_DEFAULT_MAX_FILL_RUN   (10)

typedef struct kS3dPhaseFilterClass
{
    kObjectClass base;

    // Algorithm parameters
    kSize imageWidth;
    kSize imageHeight;
    kSize phasePeriod;
    kSize minFilterRun;
    kSize maxFillRun;

    kVsJobQueue jobQueue;

    kArray2 inputStripePhaseMap;

} kS3dPhaseFilterClass;

kDeclareClassEx(kVs, kS3dPhaseFilter, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dPhaseFilter_VInitClone(kS3dPhaseFilter filter, kS3dPhaseFilter source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseFilter_VRelease(kS3dPhaseFilter filter);
kVsFx(kSize)   kS3dPhaseFilter_VSize(kS3dPhaseFilter filter);

//non-exported (private) methods
kStatus kS3dPhaseFilter_Init(kS3dPhaseFilter filter, kAlloc allocator);

kVsFx(kStatus) kS3dPhaseFilter_FilterCode(kS3dPhaseFilter filter, kArray2 stripePhaseMap, kSize startRow, kSize rowCount);
kVsFx(kStatus) kS3dPhaseFilter_FillCode(kS3dPhaseFilter filter, kArray2 stripePhaseMap, kSize startRow, kSize rowCount);

kStatus kCall kS3dPhaseFilter_FilterCodeHandler(kS3dPhaseFilter filter, k64u id);
kStatus kCall kS3dPhaseFilter_FillCodeHandler(kS3dPhaseFilter filter, k64u id);

//semi-private methods (API can change any time)
kVsFx(kStatus) kS3dPhaseFilter_SetJobQueue(kS3dPhaseFilter filter, kVsJobQueue queue);


//cast macro

#endif  /* #ifndef kS3D_PHASE_FILTER_X_H */
