/**
* @file    kS3dPhaseCombiner.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef kS3D_PHASE_COMBINER_X_H
#define kS3D_PHASE_COMBINER_X_H

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseCombinerClass
{
    kObjectClass base;

    // Algorithm parameters
    kSize imageWidth;
    kSize imageHeight;
    kSize sequenceCount;
    kSize intensitySequenceIndex;
    kSize phasePeriod;     // SplitPixel2() prerequisite 

    kVsJobQueue jobQueue;
    kSize acquiredCount;
    kArray2 output;        // kArray2<kPhasePixel2> (imageHeight, imageWidth)
    kArray2 intensityBest;

    // Input handles 
    kArray2 inputStripeMap;
    kArray2 inputPhaseMap;

} kS3dPhaseCombinerClass;

kDeclareClassEx(kVs, kS3dPhaseCombiner, kObject)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

//semi-private exported functions (virtual override methods)
kVsFx(kStatus) kS3dPhaseCombiner_VInitClone(kS3dPhaseCombiner combiner, kS3dPhaseCombiner source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseCombiner_VRelease(kS3dPhaseCombiner combiner);
kVsFx(kSize)   kS3dPhaseCombiner_VSize(kS3dPhaseCombiner combiner);

//non-exported (private) methods
kStatus kS3dPhaseCombiner_Init(kS3dPhaseCombiner combiner, kAlloc allocator);

kStatus kS3dPhaseCombiner_UpdateRows(kS3dPhaseCombiner combiner, kArray2 stripeMap, kArray2 phaseMap, kSize startRow, kSize rowCount);
kStatus kCall kS3dPhaseCombiner_UpdateRowsHandler(kS3dPhaseCombiner combiner, k64u id);

kStatus kS3dPhaseCombiner_UpdatePixel2Rows(kS3dPhaseCombiner combiner, kArray2 phaseMap, kSize startRow, kSize rowCount);
kStatus kCall kS3dPhaseCombiner_UpdatePixel2RowsHandler(kS3dPhaseCombiner combiner, k64u id);

//semi-private methods (API can change any time)
kVsFx(kStatus) kS3dPhaseCombiner_SetJobQueue(kS3dPhaseCombiner combiner, kVsJobQueue queue);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kS3D_PHASE_COMBINER_X_H */
