/**
* @file    kS3dOmcFile.x.h
* @brief   Declares the kS3dOmcFile class.
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_S3D_OMC_X_H
#define KVISION_S3D_OMC_X_H

#define KVISION_S3D_WINDOWS_DEBUG

#define kS3D_OMCFILE_CAMERA_MAX_COUNT     (2)

typedef struct omcTransformType
{
    k32f xx, xy, xz;
    k32f yx, yy, yz;
    k32f zx, zy, zz;
    k32f xt, yt, zt;
} omcTransformType;

typedef struct OMCHeaderType 
{
    k8s              fileIdentity[20];
    omcTransformType Transform;
    k32f             xscale;
    k32f             yscale;
    k32f             zscale;
    k16s             lineLen;
    k16s             lineCount;
    k16s             compress;
    k8s              Coord;
    k32f             xmin;
    k32f             xmax;
    k32f             ymin;
    k32f             ymax;
    k32f             zmin;
    k32f             zmax;
    k32s             count1;
    k32s             count2;
    k32s             count3;
    k32s             count4;
    k16s             camSizeX;
    k16s             camSizeY;
    k16s             index1;
    k16s             index2;
    k16s             index3;
    k16s             index4;
    k16s             index5;
    k16s             pictureType;
    k32s             count5;
    k32s             count6;
    k16s             index6;
    k32s             count7;
    k16s             index7;
    k32s             count8;
    k16s             index8;
    k32f             SkalaPh;
    k8s              reserved[768];
} OMCHeaderType;


typedef struct kS3dOmcFileParams
{
    k64f zResolution; 
    k64f latScale;    
    k32s depthSizeX;
    k32s depthSizeY;
    kBool initPow;    
    k32s  textureType;
    k32s  reserved[20];
}kS3dOmcFileParams;

typedef struct kS3dOmcFileClass
{
    kObjectClass base;
    kS3dOmcFileParams params;
    k32s zMin;
    k32s zMax;

    kArray2 data;      
    kArray2 pow;     
    kArray2 temp;
    kImage  viewImage;  
    kImage  scaleImage; 
    k64f viewMin;
    k64f viewMax;
    k64f scaleMin;
    k16s scaleCount;
    k64f step;
    kText32 unit;
}kS3dOmcFileClass;


kDeclareClassEx(kVs, kS3dOmcFile, kObject)

kStatus kS3dOmcFile_Init(kS3dOmcFile omc, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dOmcFile_VRelease(kS3dOmcFile omc);
kStatus kS3dOmcFile_SetDefaultSettings(kS3dOmcFile omc);
kStatus kS3dOmcFile_CopyArray2Data(kS3dOmcFile omc, kArray2 inputArray, kS3dArray2DataType type);
kStatus kS3dOmcFile_Read(kS3dOmcFile omc, const kChar *fileName);
kStatus kS3dOmcFile_Write(kS3dOmcFile omc, const kChar *fileName);
kVsFx(kStatus) kS3dOmcFile_NormalizeValidArea(kS3dOmcFile omc, kBool bAdd);
kVsFx(kStatus) kS3dOmcFile_UpdateValidRange(kS3dOmcFile omc);
kVsFx(kStatus) kS3dOmcFile_SetValidRange(kS3dOmcFile omc, k32s minZ, k32s maxZ);

kStatus kS3dOmcFile_DrawArray2Data(kS3dOmcFile omc, kArray2 input, kS3dVolumeCheckSubPixLut subPixLut, kS3dArray2DataType type);

kVsFx(kStatus) kS3dOmcFile_Array2Point3dToOmcRoi(kS3dOmcFile *omc, kArray2 inputArray, k64f latScale, k64f zResolution, kRect3d64f roi, kS3dArray2DataType type);
kVsFx(kStatus) kS3dOmcFile_Array2Point3dToOmc(kS3dOmcFile *omc, kArray2 inputArray, k64f latScale, k64f zResolution, kS3dArray2DataType type);

kStatus kS3dOmcFile_FillArray2Data16S(kS3dOmcFile omc, kArray2 input, kArray2 weight, kS3dVolumeCheckSubPixLut subPixLut);
kStatus kS3dOmcFile_FillArray2Data32S(kS3dOmcFile omc, kArray2 input, kArray2 weight, kS3dVolumeCheckSubPixLut subPixLut);
kStatus kS3dOmcFile_FillArray2Data32F(kS3dOmcFile omc, kArray2 input, kArray2 weight, kS3dVolumeCheckSubPixLut subPixLut);
kStatus kS3dOmcFile_FillArray2Data64F(kS3dOmcFile omc, kArray2 input, kArray2 weight, kS3dVolumeCheckSubPixLut subPixLut);

kStatus kS3dOmcFile_CopyImageData(kS3dOmcFile omc, kImage image);
kStatus kS3dOmcFile_ImageToOmc(kS3dOmcFile *omc, kImage image);


kStatus kS3dOmcFile_DrawScale(kS3dOmcFile omcFile, kArray1 palette, k32s width, k32s height);
kStatus kS3dOmcFile_SetViewScale(kS3dOmcFile omcFile, const kChar *zUnit);
kStatus kS3dOmcFile_SetArgbValue(kArgb* rgbColor, k32u value);

#ifdef KVISION_S3D_WINDOWS_DEBUG
kStatus kS3dOmcFile_WriteWindows(kS3dOmcFile omc, const kChar *fileName);
#endif

#define kS3DOMCFILE(HANDLE) ((kS3dOmcFileClass*)(HANDLE))

#endif  /* #ifndef KVISION_S3D_OMC_X_H */
