/**
 * @file    ${filename_header_public}}
 * @brief   Declares the ${classname} class.
 *
 * @internal
 * Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_MONO_MERGE_ALG_H
#define kVS_MONO_MERGE_ALG_H

#include <kVision/Common/kVision.h>

/**
 * @class                    kS3dMonoMergeAlg
 * @extends                  kObject
 * @ingroup                  kVision - S3d
 * @brief                    Algorithm class for merging mono and stereo meshes
 */

typedef kObject kS3dMonoMergeAlg;

/**
 * Constructs a kS3dMonoMergeAlg object.
 *
 * @public                   @memberof kS3dMonoMergeAlg
 * @param   alg              Destination for the constructed object handle.
 * @param   allocator        Memory allocator (or kNULL for default).
 * @return                   Operation status.
 */

kVsFx(kStatus) kS3dMonoMergeAlg_Construct(kS3dMonoMergeAlg* alg, kAlloc allocator);

/**
 * Merge mono and stereo meshes by applying a quadratic transformation and than blend the seems to avoid artifacts..
 *
 * @public                   @memberof kS3dMonoMergeAlg
 * @param   alg              alg object
 * @param   stereo           stereo point grid
 * @param   mono0            left camera mono point grid
 * @param   mono1            right camera mono point grid
 * @return                   Operation status.
 */

kVsFx(kStatus) kS3dMonoMergeAlg_MergeQuadratic(kS3dMonoMergeAlg alg, kArray2 stereo, kArray2 mono0, kArray2 mono1);

/**
 * Set merge threshold value. 
 * Used for outlier removal as an average multiplier during the sampling stage.
 *
 * @public                   @memberof kS3dMonoMergeAlg
 * @param   alg              alg object
 * @param   tol              tolerance for what can be considered an outlier.
 * @return                   Operation status.
 */

kInlineFx(kStatus) kS3dMonoMergeAlg_SetOutlierTolerance(kS3dMonoMergeAlg alg, k64f tol);

/**
 * Get merge threshold value.
 * Used for outlier removal as an average multiplier during the sampling stage.
 *
 * @public                   @memberof kS3dMonoMergeAlg
 * @param   alg              alg object
 * @param   tol              tolerance for what can be considered an outlier.
 * @return                   Operation status.
 */

kInlineFx(kStatus) kS3dMonoMergeAlg_OutlierTolerance(kS3dMonoMergeAlg alg, k64f* tol);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#include <kVision/S3d/kS3dMonoMergeAlg.x.h>

#endif  /* kVS_MONO_MERGE_ALG_H */
