#ifndef KVISION_S3D_GEOMETRIYUTILITIES_X_H
#define KVISION_S3D_GEOMETRIYUTILITIES_X_H

typedef struct kS3dGeometryUtilitiesClass
{
    kObjectClass base;

    k32s imageSizeX;
    k32s imageSizeY;
    kPoint3d64f scale;
    kArray2 inputData;

    k64s totalTime;

} kS3dGeometryUtilitiesClass;

kDeclareClassEx(kVs, kS3dGeometryUtilities, kObject)

kStatus kS3dGeometryUtilities_Init(kS3dGeometryUtilities tools, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dGeometryUtilities_VRelease(kS3dGeometryUtilities tools);



kStatus kS3dGeometryUtilities_ResamplePoint3d16s(kS3dGeometryUtilities tools, k64f offset);
kStatus kS3dGeometryUtilities_ResamplePoint3d32s(kS3dGeometryUtilities tools, k64f offset);
kStatus kS3dGeometryUtilities_ResamplePoint3d32f(kS3dGeometryUtilities tools, k64f offset);
kStatus kS3dGeometryUtilities_ResamplePoint3d64f(kS3dGeometryUtilities tools, k64f offset);
kStatus kS3dGeometryUtilities_ResampleMap16s(kS3dGeometryUtilities tools, k64f offset);
kStatus kS3dGeometryUtilities_ResampleMap32s(kS3dGeometryUtilities tools, k64f offset);
kStatus kS3dGeometryUtilities_ResampleMap32f(kS3dGeometryUtilities tools, k64f offset);
kStatus kS3dGeometryUtilities_ResampleMap64f(kS3dGeometryUtilities tools, k64f offset);

#define S3DGEOMETRIYUTILITIES(HANDLE) ((kS3dGeometryUtilitiesClass*)kHANDLE_POINTER(HANDLE))

#endif
