/**
* @file    kS3dBm.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KS3D_SPECKLE_MATCH_ALG_BM_X_H
#define KS3D_SPECKLE_MATCH_ALG_BM_X_H

#define kS3D_BM_DISPARITY_RANGE_GRANULARITY (16)

//actually "if defined(X86{,_64})", because it supports Linux just as well
#if defined(K_WINDOWS)
#   define kS3D_BM_SSE2                     (1)
#endif

#define kS3D_BM_ALIGN                       (32)
#define kS3D_BM_TAB_COUNT                   (256)

typedef struct kS3dBmClass
{
    kS3dSpeckleMatchAlgClass base;

    kArrayList buffer;
} kS3dBmClass;

kDeclareClassEx(kVs, kS3dBm, kS3dSpeckleMatchAlg)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dBm_VRelease(kS3dBm alg);

kVsFx(kStatus) kS3dBm_VRunImpl(kS3dBm alg, kImage image0, kImage image1, kArray2 disparity);
kVsFx(kStatus) kS3dBm_VSetupImpl(kS3dBm alg);
kVsFx(k32u)    kS3dBm_VDisparityMarginImpl(kS3dBm alg);
kVsFx(k32u)    kS3dBm_VDisparityRangeGranularityImpl(kS3dBm alg);

//non-exported (private) methods
kStatus kS3dBm_Init(kS3dBm alg, kAlloc allocator);
kStatus kS3dBm_RunSse2(kS3dBm alg, kImage image0, kImage image1, kArray2 disparity);

//cast macro

#endif  /* #ifndef KS3D_SPECKLE_MATCH_ALG_BM_X_H */
