/** 
 * @file    kP3dSpotCropBlockInfo.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef kVS_SPOT_CROP_BLOCK_INFO_X_H
#define kVS_SPOT_CROP_BLOCK_INFO_X_H

#include <kApi/Utils/kUtils.h>

#define kP3D_SPOT_CROP_BLOCK_INFO_MIN_RUN_LENGTH_DEFAULT            (5)
#define kP3D_SPOT_CROP_BLOCK_INFO_SPOT_THRESHOLD_DEFAULT            (30)
#define kP3D_SPOT_CROP_BLOCK_INFO_ROI_INFLATE_PERCENT_DEFAULT       (100)
#define kP3D_SPOT_CROP_BLOCK_INFO_ROI_SKIP_PERCENT_DEFAULT          (0) // bandwidth scaling disabled by default
#define kP3D_SPOT_CROP_BLOCK_INFO_SEARCH_GRID_SIZE_DEFAULT          (3)

typedef struct kP3dSpotCropBlockInfoClass
{
    kObjectClass base;

    k32u minRunLength;
    k32u spotThreshold;
    k32u roiInflatePercent;
    k32u roiSkipPercent;
    k32u searchGridSize;
    
} kP3dSpotCropBlockInfoClass;

kDeclareClassEx(kVs, kP3dSpotCropBlockInfo, kObject)

//semi-private exported functions (virtual override methods)
kVsFx(kStatus) kP3dSpotCropBlockInfo_VInitClone(kP3dSpotCropBlockInfo info, kP3dSpotCropBlockInfo source, kAlloc allocator);
kVsFx(kStatus) kP3dSpotCropBlockInfo_VRelease(kP3dSpotCropBlockInfo info);

//non-exported (private) methods
kStatus kP3dSpotCropBlockInfo_Init(kP3dSpotCropBlockInfo info, kAlloc allocator);

//cast macro

#endif  /* #ifndef kVS_SPOT_CROP_BLOCK_INFO_X_H */
