#ifndef LMITECH_KVISION_MP3D_ALGORITHMS_H_INCLUDED
#define LMITECH_KVISION_MP3D_ALGORITHMS_H_INCLUDED

#include <kVision/Mp3d/kMp3dCommon.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArray1.h>
#include <kFireSync/Data/kSpot.h>
#include <kFireSync/Data/kBinCSum4Alg.h>
#include <stdarg.h>

#define kMP3D_FIND_SPOTS_STRENGTH(WIDTH, PEAK, SUM)               (((WIDTH) << 24) | (((PEAK) >> 4) << 16) | (SUM))
#define kMP3D_FIND_SPOTS_WIDTH(STRENGTH)                          (((STRENGTH) >> 24) & 0xFF)
#define kMP3D_FIND_SPOTS_PEAK(STRENGTH)                           (((STRENGTH) >> 12) & 0xFF0)
#define kMP3D_FIND_SPOTS_SUM(STRENGTH)                            ((STRENGTH) & 0xFFFF)

kVsFx(kStatus) kMp3dFindSpots(const kCSum4* csums, kSize count, kSize window, kSize height, kArrayList spots);
kVsFx(kStatus) kMp3dGhostFilter(kArrayList spots, k32u threshold);
kVsFx(kStatus) kMp3dSumColumns(kImage image, k32u threshold, kArray1 *sums);

#endif /* LMITECH_KVISION_MP3D_ALGORITHMS_H_INCLUDED */
