#ifndef LMITECH_KVISION_MP3D_COMMON_H_INCLUDED
#define LMITECH_KVISION_MP3D_COMMON_H_INCLUDED

#include <kFireSync/kFsDef.h>
#include <kVision/Common/kVision.h>

#include <kVision/L3d/kL3dCommon.h>

#define kMP3D_NULL_CENTROID                     (0)
#define kMP3D_NULL_RANGE                        (k16S_NULL)

#define kMP3D_TRACHEID_NULL_ANGLE               (k8U_NULL)
#define kMP3D_TRACHEID_NULL_SCATTER             (0)
#define kMP3D_TRACHEID_NULL_AREA                (0)

// LUT defaults
#define kMP3D_ID_LUT_MAX_SPOTS                  (10)
#define kMP3D_WEAK_MULTIPLES_FACTOR             (10)
#define kMP3D_ID_CORRECTION_MIN_SEPARATION      (8)
#define kMP3D_SPOT_EDGE_WINDOW                  (7)
#define kMP3D_MAX_SPOT_CAPACITY                 (1000)
#define kMP3D_RUN_THRESHOLD                     (22)
#define kMP3D_TRACHEID_WINDOW_WIDTH             (38)
#define kMP3D_SPOT_THRESHOLD                    (10)
#define kMP3D_BACKGROUND_WIDTH                  (32)
#define kMP3D_WINDOW_ROW_BUFFER                 (10)
#define kMP3D_WINDOW_COL_BUFFER                 (15)

typedef enum
{
    kMP3D_TRACHEID_TYPE_SUM = 0,
    kMP3D_TRACHEID_TYPE_SUMX = 1,
    kMP3D_TRACHEID_TYPE_SUMY = 2,
    kMP3D_TRACHEID_TYPE_SUMXX = 3,
    kMP3D_TRACHEID_TYPE_SUMXY = 4,
    kMP3D_TRACHEID_TYPE_SUMYY = 5,
    kMP3D_TRACHEID_TYPE_MOMENT_COUNT = 6
} kMp3dTracheidType;

#endif /* #ifndef LMITECH_KVISION_MP3D_COMMON_H_INCLUDED */
